/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.function.Function;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.offheap.OffHeapStoredObject;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.ReferenceCounterInstance;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.offheap.TinyStoredObject;
import org.apache.geode.internal.serialization.DSCODE;

class OffHeapRegionEntryHelperInstance {
    static final long NULL_ADDRESS = 0L;
    static final long INVALID_ADDRESS = 2L;
    static final long LOCAL_INVALID_ADDRESS = 4L;
    static final long DESTROYED_ADDRESS = 6L;
    static final long REMOVED_PHASE1_ADDRESS = 8L;
    static final long REMOVED_PHASE2_ADDRESS = 10L;
    static final long END_OF_STREAM_ADDRESS = 12L;
    static final long NOT_AVAILABLE_ADDRESS = 14L;
    static final long TOMBSTONE_ADDRESS = 16L;
    static final int MAX_LENGTH_FOR_DATA_AS_ADDRESS = 8;
    private final Function<Long, OffHeapStoredObject> offHeapStoredObjectFactory;
    private final ReferenceCounterInstance referenceCounter;
    private static final long ENCODED_BIT = 1L;
    static final long SERIALIZED_BIT = 2L;
    static final long COMPRESSED_BIT = 4L;
    private static final long LONG_BIT = 8L;
    private static final long SIZE_MASK = 112L;
    private static final int SIZE_SHIFT = 4;

    OffHeapRegionEntryHelperInstance() {
        this(OffHeapStoredObject::new, new ReferenceCounterInstance());
    }

    @VisibleForTesting
    OffHeapRegionEntryHelperInstance(Function<Long, OffHeapStoredObject> offHeapStoredObjectFactory, ReferenceCounterInstance referenceCounter) {
        this.offHeapStoredObjectFactory = offHeapStoredObjectFactory;
        this.referenceCounter = referenceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object addressToObject(long ohAddress, boolean decompress, RegionEntryContext context) {
        if (this.isOffHeap(ohAddress)) {
            OffHeapStoredObject chunk = this.offHeapStoredObjectFactory.apply(ohAddress);
            Object result = chunk;
            if (decompress && chunk.isCompressed()) {
                try {
                    byte[] decompressedBytes = chunk.getDecompressedBytes(context);
                    result = chunk.isSerialized() ? CachedDeserializableFactory.create(decompressedBytes, context.getCache()) : (Object)decompressedBytes;
                }
                finally {
                    chunk.release();
                }
            }
            return result;
        }
        if ((ohAddress & 1L) != 0L) {
            TinyStoredObject daa = new TinyStoredObject(ohAddress);
            Object result = daa;
            if (decompress && daa.isCompressed()) {
                byte[] decompressedBytes = daa.getDecompressedBytes(context);
                result = daa.isSerialized() ? CachedDeserializableFactory.create(decompressedBytes, context.getCache()) : (Object)decompressedBytes;
            }
            return result;
        }
        return TokenAddress.ADDRESS_TO_OBJECT[(int)ohAddress >> 1];
    }

    int getSerializedLength(TinyStoredObject dataAsAddress) {
        long ohAddress = dataAsAddress.getAddress();
        if ((ohAddress & 1L) != 0L) {
            boolean isLong;
            boolean bl = isLong = (ohAddress & 8L) != 0L;
            if (isLong) {
                return 9;
            }
            return (int)((ohAddress & 0x70L) >> 4);
        }
        return 0;
    }

    private Token addressToToken(long ohAddress) {
        if (this.isOffHeap(ohAddress) || (ohAddress & 1L) != 0L) {
            return Token.NOT_A_TOKEN;
        }
        return TokenAddress.ADDRESS_TO_OBJECT[(int)ohAddress >> 1];
    }

    private void releaseAddress(long ohAddress) {
        if (this.isOffHeap(ohAddress)) {
            this.referenceCounter.release(ohAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEntry(OffHeapRegionEntry regionEntry) {
        DiskId diskId;
        if (regionEntry instanceof DiskEntry && (diskId = ((DiskEntry)((Object)regionEntry)).getDiskId()) != null && diskId.isPendingAsync()) {
            DiskId diskId2 = diskId;
            synchronized (diskId2) {
                diskId.setPendingAsync(false);
                this.setValue(regionEntry, Token.REMOVED_PHASE2);
                return;
            }
        }
        this.setValue(regionEntry, Token.REMOVED_PHASE2);
    }

    public void releaseEntry(OffHeapRegionEntry regionEntry, StoredObject expectedValue) {
        long newAddress;
        long oldAddress = TokenAddress.objectToAddress(expectedValue);
        if (regionEntry.setAddress(oldAddress, newAddress = TokenAddress.objectToAddress(Token.REMOVED_PHASE2))) {
            this.releaseAddress(oldAddress);
        }
    }

    long encodeDataAsAddress(byte[] bytes, boolean isSerialized, boolean isCompressed) {
        if (bytes.length < 8) {
            long result = 0L;
            for (byte aByte : bytes) {
                result |= (long)(aByte & 0xFF);
                result <<= 8;
            }
            result |= (long)(bytes.length << 4) | 1L;
            if (isSerialized) {
                result |= 2L;
            }
            if (isCompressed) {
                result |= 4L;
            }
            return result;
        }
        if (isSerialized && !isCompressed && bytes[0] == DSCODE.LONG.toByte() && (bytes[1] == 0 && (bytes[2] & 0x80) == 0 || bytes[1] == -1 && (bytes[2] & 0x80) != 0)) {
            long result = 0L;
            for (int i = 2; i < bytes.length; ++i) {
                result |= (long)(bytes[i] & 0xFF);
                result <<= 8;
            }
            return result |= 0x7BL;
        }
        return 0L;
    }

    Object decodeAddressToObject(long ohAddress) {
        boolean isSerialized;
        byte[] bytes = this.decodeUncompressedAddressToBytes(ohAddress);
        boolean bl = isSerialized = (ohAddress & 2L) != 0L;
        if (isSerialized) {
            return EntryEventImpl.deserialize(bytes);
        }
        return bytes;
    }

    int decodeAddressToDataSize(long address) {
        boolean isLong;
        if ((address & 1L) == 0L) {
            throw new AssertionError((Object)("Invalid address: " + address));
        }
        boolean bl = isLong = (address & 8L) != 0L;
        if (isLong) {
            return 9;
        }
        return (int)((address & 0x70L) >> 4);
    }

    byte[] decodeUncompressedAddressToBytes(long addr) {
        if ((addr & 4L) != 0L) {
            throw new AssertionError((Object)"Did not expect encoded address to be compressed");
        }
        return this.decodeAddressToRawBytes(addr);
    }

    byte[] decodeAddressToRawBytes(long addr) {
        byte[] bytes;
        boolean isLong;
        if ((addr & 1L) == 0L) {
            throw new AssertionError((Object)("Invalid address: " + addr));
        }
        int size = (int)((addr & 0x70L) >> 4);
        boolean bl = isLong = (addr & 8L) != 0L;
        if (isLong) {
            bytes = new byte[9];
            bytes[0] = DSCODE.LONG.toByte();
            for (int i = 8; i >= 2; --i) {
                bytes[i] = (byte)((addr >>= 8) & 0xFFL);
            }
            bytes[1] = (bytes[2] & 0x80) != 0 ? -1 : 0;
        } else {
            bytes = new byte[size];
            for (int i = size - 1; i >= 0; --i) {
                bytes[i] = (byte)((addr >>= 8) & 0xFFL);
            }
        }
        return bytes;
    }

    public void setValue(OffHeapRegionEntry regionEntry, Object value) {
        long oldAddress;
        long newAddress = TokenAddress.objectToAddress(value);
        while (!regionEntry.setAddress(oldAddress = regionEntry.getAddress(), newAddress)) {
        }
        ReferenceCountHelper.setReferenceCountOwner(regionEntry);
        this.releaseAddress(oldAddress);
        ReferenceCountHelper.setReferenceCountOwner(null);
    }

    public Token getValueAsToken(OffHeapRegionEntry regionEntry) {
        return this.addressToToken(regionEntry.getAddress());
    }

    public Object _getValue(OffHeapRegionEntry regionEntry) {
        return this.addressToObject(regionEntry.getAddress(), false, null);
    }

    public boolean isOffHeap(long address) {
        if ((address & 1L) != 0L) {
            return false;
        }
        if (address < 0L) {
            return true;
        }
        return (address >>= 1) >= (long)TokenAddress.ADDRESS_TO_OBJECT.length;
    }

    public Object _getValueRetain(OffHeapRegionEntry regionEntry, boolean decompress, RegionEntryContext context) {
        int retryCount = 0;
        long address = regionEntry.getAddress();
        while (this.isOffHeap(address)) {
            long address2;
            if (this.referenceCounter.retain(address)) {
                address2 = regionEntry.getAddress();
                if (address != address2) {
                    retryCount = 0;
                    this.referenceCounter.release(address);
                    address = address2;
                    continue;
                }
                return this.addressToObject(address, decompress, context);
            }
            address2 = regionEntry.getAddress();
            if (++retryCount > 100) {
                throw new IllegalStateException("retain failed address=" + address + " addr2=" + address + " 100 times history=" + ReferenceCountHelper.getFreeRefCountInfo(address));
            }
            address = address2;
        }
        return this.addressToObject(address, decompress, context);
    }

    public boolean isSerialized(long address) {
        return (address & 2L) != 0L;
    }

    public boolean isCompressed(long address) {
        return (address & 4L) != 0L;
    }

    private static class TokenAddress {
        @Immutable
        private static final Token[] ADDRESS_TO_OBJECT = new Token[]{null, Token.INVALID, Token.LOCAL_INVALID, Token.DESTROYED, Token.REMOVED_PHASE1, Token.REMOVED_PHASE2, Token.END_OF_STREAM, Token.NOT_AVAILABLE, Token.TOMBSTONE};

        private TokenAddress() {
        }

        private static long objectToAddress(Object v) {
            if (v instanceof StoredObject) {
                return ((StoredObject)v).getAddress();
            }
            if (v == null) {
                return 0L;
            }
            if (v == Token.TOMBSTONE) {
                return 16L;
            }
            if (v == Token.INVALID) {
                return 2L;
            }
            if (v == Token.LOCAL_INVALID) {
                return 4L;
            }
            if (v == Token.DESTROYED) {
                return 6L;
            }
            if (v == Token.REMOVED_PHASE1) {
                return 8L;
            }
            if (v == Token.REMOVED_PHASE2) {
                return 10L;
            }
            if (v == Token.END_OF_STREAM) {
                return 12L;
            }
            if (v == Token.NOT_AVAILABLE) {
                return 14L;
            }
            throw new IllegalStateException("Can not convert " + v + " to an off heap address.");
        }
    }
}

