/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;

public abstract class AbstractFunctionRunner
extends ProcessFunction<RowData, RowData> {
    private final GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher;
    protected transient FlatMapFunction<RowData, RowData> fetcher;

    public AbstractFunctionRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher) {
        this.generatedFetcher = generatedFetcher;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.fetcher = (FlatMapFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (OpenContext)openContext);
    }

    public void close() throws Exception {
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        super.close();
    }
}

