/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop;

import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.PartETag;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.fs.osshadoop.common.HadoopFileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;

public class OSSAccessor {
    private AliyunOSSFileSystem fs;
    private AliyunOSSFileSystemStore store;

    public OSSAccessor(AliyunOSSFileSystem fs) {
        this.fs = fs;
        this.store = fs.getStore();
    }

    public String pathToObject(Path path) {
        org.apache.hadoop.fs.Path hadoopPath = HadoopFileSystem.toHadoopPath(path);
        if (!hadoopPath.isAbsolute()) {
            hadoopPath = new org.apache.hadoop.fs.Path(this.fs.getWorkingDirectory(), hadoopPath);
        }
        return hadoopPath.toUri().getPath().substring(1);
    }

    public Path objectToPath(String object) {
        return new Path("/" + object);
    }

    public String startMultipartUpload(String objectName) {
        return this.store.getUploadId(objectName);
    }

    public boolean deleteObject(String objectName) throws IOException {
        return this.fs.delete(new org.apache.hadoop.fs.Path('/' + objectName), false);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String objectName, String uploadId, List<PartETag> partETags) {
        return this.store.completeMultipartUpload(objectName, uploadId, partETags);
    }

    public PartETag uploadPart(File file, String objectName, String uploadId, int idx) throws IOException {
        return this.store.uploadPart(file, objectName, uploadId, idx);
    }

    public void putObject(String objectName, File file) throws IOException {
        this.store.uploadObject(objectName, file);
    }

    public void getObject(String objectName, String dstPath, long length) throws IOException {
        long contentLength = this.store.getObjectMetadata(objectName).getContentLength();
        if (contentLength != length) {
            throw new IOException(String.format("Error recovering writer: Downloading the last data chunk file gives incorrect length.File length is %d bytes, RecoveryData indicates %d bytes", contentLength, length));
        }
        org.apache.hadoop.fs.Path srcPath = new org.apache.hadoop.fs.Path("/" + objectName);
        org.apache.hadoop.fs.Path localPath = new org.apache.hadoop.fs.Path(dstPath);
        this.fs.copyToLocalFile(srcPath, localPath);
        String crcFileName = "." + localPath.getName() + ".crc";
        new File(localPath.getParent().toString() + "/" + crcFileName).delete();
    }
}

