/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.Tuple;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.RetryAlgorithmManager;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Objects;

class BlobReadChannel
implements ReadChannel {
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;
    private final StorageOptions serviceOptions;
    private final BlobId blob;
    private final Map<StorageRpc.Option, ?> requestOptions;
    private final RetryAlgorithmManager retryAlgorithmManager;
    private String lastEtag;
    private long position;
    private boolean isOpen;
    private boolean endOfStream;
    private int chunkSize = 0x200000;
    private final StorageRpc storageRpc;
    private final StorageObject storageObject;
    private int bufferPos;
    private byte[] buffer;

    BlobReadChannel(StorageOptions serviceOptions, BlobId blob, Map<StorageRpc.Option, ?> requestOptions) {
        this.serviceOptions = serviceOptions;
        this.blob = blob;
        this.requestOptions = requestOptions;
        this.retryAlgorithmManager = serviceOptions.getRetryAlgorithmManager();
        this.isOpen = true;
        this.storageRpc = serviceOptions.getStorageRpcV1();
        this.storageObject = blob.toPb();
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        StateImpl.Builder builder = StateImpl.builder(this.serviceOptions, this.blob, this.requestOptions).setPosition(this.position).setIsOpen(this.isOpen).setEndOfStream(this.endOfStream).setChunkSize(this.chunkSize);
        if (this.buffer != null) {
            builder.setPosition(this.position + (long)this.bufferPos);
            builder.setEndOfStream(false);
        }
        return builder.build();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.buffer = null;
            this.isOpen = false;
        }
    }

    private void validateOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public void seek(long position) throws IOException {
        this.validateOpen();
        this.position = position;
        this.buffer = null;
        this.bufferPos = 0;
        this.endOfStream = false;
    }

    @Override
    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize <= 0 ? 0x200000 : chunkSize;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.validateOpen();
        if (this.buffer == null) {
            if (this.endOfStream) {
                return -1;
            }
            int toRead = Math.max(byteBuffer.remaining(), this.chunkSize);
            try {
                ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(this.storageObject, this.requestOptions);
                Tuple result = RetryHelper.runWithRetries(() -> this.storageRpc.read(this.storageObject, this.requestOptions, this.position, toRead), this.serviceOptions.getRetrySettings(), algorithm, this.serviceOptions.getClock());
                String etag = (String)result.x();
                byte[] bytes = (byte[])result.y();
                if (bytes.length > 0 && this.lastEtag != null && !Objects.equals(etag, this.lastEtag)) {
                    throw new IOException("Blob " + this.blob + " was updated while reading");
                }
                this.lastEtag = etag;
                this.buffer = bytes;
            }
            catch (RetryHelper.RetryHelperException e) {
                throw new IOException(e);
            }
            if (toRead > this.buffer.length) {
                this.endOfStream = true;
                if (this.buffer.length == 0) {
                    this.buffer = null;
                    return -1;
                }
            }
        }
        int toWrite = Math.min(this.buffer.length - this.bufferPos, byteBuffer.remaining());
        byteBuffer.put(this.buffer, this.bufferPos, toWrite);
        this.bufferPos += toWrite;
        if (this.bufferPos >= this.buffer.length) {
            this.position += (long)this.buffer.length;
            this.buffer = null;
            this.bufferPos = 0;
        }
        return toWrite;
    }

    static class StateImpl
    implements RestorableState<ReadChannel>,
    Serializable {
        private static final long serialVersionUID = 3889420316004453706L;
        private final StorageOptions serviceOptions;
        private final BlobId blob;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final String lastEtag;
        private final long position;
        private final boolean isOpen;
        private final boolean endOfStream;
        private final int chunkSize;

        StateImpl(Builder builder) {
            this.serviceOptions = builder.serviceOptions;
            this.blob = builder.blob;
            this.requestOptions = builder.requestOptions;
            this.lastEtag = builder.lastEtag;
            this.position = builder.position;
            this.isOpen = builder.isOpen;
            this.endOfStream = builder.endOfStream;
            this.chunkSize = builder.chunkSize;
        }

        static Builder builder(StorageOptions options, BlobId blob, Map<StorageRpc.Option, ?> reqOptions) {
            return new Builder(options, blob, reqOptions);
        }

        @Override
        public ReadChannel restore() {
            BlobReadChannel channel = new BlobReadChannel(this.serviceOptions, this.blob, this.requestOptions);
            channel.lastEtag = this.lastEtag;
            channel.position = this.position;
            channel.isOpen = this.isOpen;
            channel.endOfStream = this.endOfStream;
            channel.chunkSize = this.chunkSize;
            return channel;
        }

        public int hashCode() {
            return Objects.hash(this.serviceOptions, this.blob, this.requestOptions, this.lastEtag, this.position, this.isOpen, this.endOfStream, this.chunkSize);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals(this.serviceOptions, other.serviceOptions) && Objects.equals(this.blob, other.blob) && Objects.equals(this.requestOptions, other.requestOptions) && Objects.equals(this.lastEtag, other.lastEtag) && this.position == other.position && this.isOpen == other.isOpen && this.endOfStream == other.endOfStream && this.chunkSize == other.chunkSize;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("blob", this.blob).add("position", this.position).add("isOpen", this.isOpen).add("endOfStream", this.endOfStream).toString();
        }

        static class Builder {
            private final StorageOptions serviceOptions;
            private final BlobId blob;
            private final Map<StorageRpc.Option, ?> requestOptions;
            private String lastEtag;
            private long position;
            private boolean isOpen;
            private boolean endOfStream;
            private int chunkSize;

            private Builder(StorageOptions options, BlobId blob, Map<StorageRpc.Option, ?> reqOptions) {
                this.serviceOptions = options;
                this.blob = blob;
                this.requestOptions = reqOptions;
            }

            Builder setLastEtag(String lastEtag) {
                this.lastEtag = lastEtag;
                return this;
            }

            Builder setPosition(long position) {
                this.position = position;
                return this;
            }

            Builder setIsOpen(boolean isOpen) {
                this.isOpen = isOpen;
                return this;
            }

            Builder setEndOfStream(boolean endOfStream) {
                this.endOfStream = endOfStream;
                return this;
            }

            Builder setChunkSize(int chunkSize) {
                this.chunkSize = chunkSize;
                return this;
            }

            RestorableState<ReadChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

