/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.iamcredentials.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.iamcredentials.v1.IAMCredentialsRequest;
import com.google.api.services.iamcredentials.v1.IAMCredentialsRequestInitializer;
import com.google.api.services.iamcredentials.v1.model.GenerateAccessTokenRequest;
import com.google.api.services.iamcredentials.v1.model.GenerateAccessTokenResponse;
import com.google.api.services.iamcredentials.v1.model.GenerateIdTokenRequest;
import com.google.api.services.iamcredentials.v1.model.GenerateIdTokenResponse;
import com.google.api.services.iamcredentials.v1.model.SignBlobRequest;
import com.google.api.services.iamcredentials.v1.model.SignBlobResponse;
import com.google.api.services.iamcredentials.v1.model.SignJwtRequest;
import com.google.api.services.iamcredentials.v1.model.SignJwtResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class IAMCredentials
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://iamcredentials.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://iamcredentials.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://iamcredentials.googleapis.com/";

    public IAMCredentials(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    IAMCredentials(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1), "You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the IAM Service Account Credentials API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return IAMCredentials.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://iamcredentials.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), IAMCredentials.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(IAMCredentials.DEFAULT_BATCH_PATH);
        }

        @Override
        public IAMCredentials build() {
            return new IAMCredentials(this);
        }

        @Override
        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        @Override
        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        @Override
        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        @Override
        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        @Override
        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        @Override
        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        @Override
        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        @Override
        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setIAMCredentialsRequestInitializer(IAMCredentialsRequestInitializer iamcredentialsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(iamcredentialsRequestInitializer);
        }

        @Override
        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public ServiceAccounts serviceAccounts() {
            return new ServiceAccounts();
        }

        public class ServiceAccounts {
            public GenerateAccessToken generateAccessToken(String name, GenerateAccessTokenRequest content) throws IOException {
                GenerateAccessToken result = new GenerateAccessToken(name, content);
                IAMCredentials.this.initialize(result);
                return result;
            }

            public GenerateIdToken generateIdToken(String name, GenerateIdTokenRequest content) throws IOException {
                GenerateIdToken result = new GenerateIdToken(name, content);
                IAMCredentials.this.initialize(result);
                return result;
            }

            public SignBlob signBlob(String name, SignBlobRequest content) throws IOException {
                SignBlob result = new SignBlob(name, content);
                IAMCredentials.this.initialize(result);
                return result;
            }

            public SignJwt signJwt(String name, SignJwtRequest content) throws IOException {
                SignJwt result = new SignJwt(name, content);
                IAMCredentials.this.initialize(result);
                return result;
            }

            public class SignJwt
            extends IAMCredentialsRequest<SignJwtResponse> {
                private static final String REST_PATH = "v1/{+name}:signJwt";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignJwt(String name, SignJwtRequest content) {
                    super(IAMCredentials.this, "POST", REST_PATH, (Object)content, SignJwtResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignJwt set$Xgafv(String $Xgafv) {
                    return (SignJwt)super.set$Xgafv($Xgafv);
                }

                public SignJwt setAccessToken(String accessToken) {
                    return (SignJwt)super.setAccessToken(accessToken);
                }

                public SignJwt setAlt(String alt) {
                    return (SignJwt)super.setAlt(alt);
                }

                public SignJwt setCallback(String callback) {
                    return (SignJwt)super.setCallback(callback);
                }

                public SignJwt setFields(String fields) {
                    return (SignJwt)super.setFields(fields);
                }

                public SignJwt setKey(String key) {
                    return (SignJwt)super.setKey(key);
                }

                public SignJwt setOauthToken(String oauthToken) {
                    return (SignJwt)super.setOauthToken(oauthToken);
                }

                public SignJwt setPrettyPrint(Boolean prettyPrint) {
                    return (SignJwt)super.setPrettyPrint(prettyPrint);
                }

                public SignJwt setQuotaUser(String quotaUser) {
                    return (SignJwt)super.setQuotaUser(quotaUser);
                }

                public SignJwt setUploadType(String uploadType) {
                    return (SignJwt)super.setUploadType(uploadType);
                }

                public SignJwt setUploadProtocol(String uploadProtocol) {
                    return (SignJwt)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public SignJwt setName(String name) {
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public SignJwt set(String parameterName, Object value) {
                    return (SignJwt)super.set(parameterName, value);
                }
            }

            public class SignBlob
            extends IAMCredentialsRequest<SignBlobResponse> {
                private static final String REST_PATH = "v1/{+name}:signBlob";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignBlob(String name, SignBlobRequest content) {
                    super(IAMCredentials.this, "POST", REST_PATH, (Object)content, SignBlobResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignBlob set$Xgafv(String $Xgafv) {
                    return (SignBlob)super.set$Xgafv($Xgafv);
                }

                public SignBlob setAccessToken(String accessToken) {
                    return (SignBlob)super.setAccessToken(accessToken);
                }

                public SignBlob setAlt(String alt) {
                    return (SignBlob)super.setAlt(alt);
                }

                public SignBlob setCallback(String callback) {
                    return (SignBlob)super.setCallback(callback);
                }

                public SignBlob setFields(String fields) {
                    return (SignBlob)super.setFields(fields);
                }

                public SignBlob setKey(String key) {
                    return (SignBlob)super.setKey(key);
                }

                public SignBlob setOauthToken(String oauthToken) {
                    return (SignBlob)super.setOauthToken(oauthToken);
                }

                public SignBlob setPrettyPrint(Boolean prettyPrint) {
                    return (SignBlob)super.setPrettyPrint(prettyPrint);
                }

                public SignBlob setQuotaUser(String quotaUser) {
                    return (SignBlob)super.setQuotaUser(quotaUser);
                }

                public SignBlob setUploadType(String uploadType) {
                    return (SignBlob)super.setUploadType(uploadType);
                }

                public SignBlob setUploadProtocol(String uploadProtocol) {
                    return (SignBlob)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public SignBlob setName(String name) {
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public SignBlob set(String parameterName, Object value) {
                    return (SignBlob)super.set(parameterName, value);
                }
            }

            public class GenerateIdToken
            extends IAMCredentialsRequest<GenerateIdTokenResponse> {
                private static final String REST_PATH = "v1/{+name}:generateIdToken";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GenerateIdToken(String name, GenerateIdTokenRequest content) {
                    super(IAMCredentials.this, "POST", REST_PATH, (Object)content, GenerateIdTokenResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public GenerateIdToken set$Xgafv(String $Xgafv) {
                    return (GenerateIdToken)super.set$Xgafv($Xgafv);
                }

                public GenerateIdToken setAccessToken(String accessToken) {
                    return (GenerateIdToken)super.setAccessToken(accessToken);
                }

                public GenerateIdToken setAlt(String alt) {
                    return (GenerateIdToken)super.setAlt(alt);
                }

                public GenerateIdToken setCallback(String callback) {
                    return (GenerateIdToken)super.setCallback(callback);
                }

                public GenerateIdToken setFields(String fields) {
                    return (GenerateIdToken)super.setFields(fields);
                }

                public GenerateIdToken setKey(String key) {
                    return (GenerateIdToken)super.setKey(key);
                }

                public GenerateIdToken setOauthToken(String oauthToken) {
                    return (GenerateIdToken)super.setOauthToken(oauthToken);
                }

                public GenerateIdToken setPrettyPrint(Boolean prettyPrint) {
                    return (GenerateIdToken)super.setPrettyPrint(prettyPrint);
                }

                public GenerateIdToken setQuotaUser(String quotaUser) {
                    return (GenerateIdToken)super.setQuotaUser(quotaUser);
                }

                public GenerateIdToken setUploadType(String uploadType) {
                    return (GenerateIdToken)super.setUploadType(uploadType);
                }

                public GenerateIdToken setUploadProtocol(String uploadProtocol) {
                    return (GenerateIdToken)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GenerateIdToken setName(String name) {
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GenerateIdToken set(String parameterName, Object value) {
                    return (GenerateIdToken)super.set(parameterName, value);
                }
            }

            public class GenerateAccessToken
            extends IAMCredentialsRequest<GenerateAccessTokenResponse> {
                private static final String REST_PATH = "v1/{+name}:generateAccessToken";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GenerateAccessToken(String name, GenerateAccessTokenRequest content) {
                    super(IAMCredentials.this, "POST", REST_PATH, (Object)content, GenerateAccessTokenResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public GenerateAccessToken set$Xgafv(String $Xgafv) {
                    return (GenerateAccessToken)super.set$Xgafv($Xgafv);
                }

                public GenerateAccessToken setAccessToken(String accessToken) {
                    return (GenerateAccessToken)super.setAccessToken(accessToken);
                }

                public GenerateAccessToken setAlt(String alt) {
                    return (GenerateAccessToken)super.setAlt(alt);
                }

                public GenerateAccessToken setCallback(String callback) {
                    return (GenerateAccessToken)super.setCallback(callback);
                }

                public GenerateAccessToken setFields(String fields) {
                    return (GenerateAccessToken)super.setFields(fields);
                }

                public GenerateAccessToken setKey(String key) {
                    return (GenerateAccessToken)super.setKey(key);
                }

                public GenerateAccessToken setOauthToken(String oauthToken) {
                    return (GenerateAccessToken)super.setOauthToken(oauthToken);
                }

                public GenerateAccessToken setPrettyPrint(Boolean prettyPrint) {
                    return (GenerateAccessToken)super.setPrettyPrint(prettyPrint);
                }

                public GenerateAccessToken setQuotaUser(String quotaUser) {
                    return (GenerateAccessToken)super.setQuotaUser(quotaUser);
                }

                public GenerateAccessToken setUploadType(String uploadType) {
                    return (GenerateAccessToken)super.setUploadType(uploadType);
                }

                public GenerateAccessToken setUploadProtocol(String uploadProtocol) {
                    return (GenerateAccessToken)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GenerateAccessToken setName(String name) {
                    if (!IAMCredentials.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument(this.NAME_PATTERN.matcher(name).matches(), "Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GenerateAccessToken set(String parameterName, Object value) {
                    return (GenerateAccessToken)super.set(parameterName, value);
                }
            }
        }
    }
}

