/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;

@Internal
public class SerdeContext {
    static final String SERDE_CONTEXT_KEY = "serdeCtx";
    private final Parser parser;
    private final FlinkContext flinkContext;
    private final FlinkTypeFactory typeFactory;
    private final SqlOperatorTable operatorTable;
    private final RexBuilder rexBuilder;

    public SerdeContext(Parser parser, FlinkContext flinkContext, FlinkTypeFactory typeFactory, SqlOperatorTable operatorTable) {
        this.parser = parser;
        this.flinkContext = flinkContext;
        this.typeFactory = typeFactory;
        this.operatorTable = operatorTable;
        this.rexBuilder = new RexBuilder(typeFactory);
    }

    public static SerdeContext get(DatabindContext databindContext) {
        SerdeContext serdeContext = (SerdeContext)databindContext.getAttribute((Object)SERDE_CONTEXT_KEY);
        assert (serdeContext != null);
        return serdeContext;
    }

    public Parser getParser() {
        return this.parser;
    }

    public ReadableConfig getConfiguration() {
        return this.flinkContext.getTableConfig();
    }

    public ClassLoader getClassLoader() {
        return this.flinkContext.getClassLoader();
    }

    public FlinkContext getFlinkContext() {
        return this.flinkContext;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SqlOperatorTable getOperatorTable() {
        return this.operatorTable;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }
}

