/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class StructuredToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<ArrayData, String> {
    static final StructuredToStringCastRule INSTANCE = new StructuredToStringCastRule();

    private StructuredToStringCastRule() {
        super(CastRulePredicate.builder().predicate(StructuredToStringCastRule::matches).build());
    }

    private static boolean matches(LogicalType input, LogicalType target) {
        return target.is(LogicalTypeFamily.CHARACTER_STRING) && input.is(LogicalTypeRoot.STRUCTURED_TYPE) && LogicalTypeChecks.getFieldTypes((LogicalType)input).stream().allMatch(fieldType -> CastRuleProvider.exists(fieldType, target));
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        StructuredType inputStructuredType = (StructuredType)inputLogicalType;
        String builderTerm = CodeGenUtils.newName("builder");
        context.declareClassField(CodeGenUtils.className(StringBuilder.class), builderTerm, CastRuleUtils.constructorCall(StringBuilder.class, new Object[0]));
        String resultStringTerm = CodeGenUtils.newName("resultString");
        int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter().stmt(CastRuleUtils.methodCall(builderTerm, "setLength", 0)).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("(")));
        for (int i = 0; i < inputStructuredType.getAttributes().size(); ++i) {
            int fieldIndex = i;
            StructuredType.StructuredAttribute attribute = (StructuredType.StructuredAttribute)inputStructuredType.getAttributes().get(fieldIndex);
            String fieldTerm = CodeGenUtils.newName("f" + fieldIndex + "Value");
            String fieldIsNullTerm = CodeGenUtils.newName("f" + fieldIndex + "IsNull");
            CastCodeBlock codeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, fieldTerm, attribute.getType(), (LogicalType)VarCharType.STRING_TYPE);
            if (fieldIndex != 0) {
                writer.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(", ")));
            }
            writer.declPrimitiveStmt(attribute.getType(), fieldTerm).declStmt(Boolean.TYPE, fieldIsNullTerm, CastRuleUtils.methodCall(inputTerm, "isNullAt", fieldIndex)).ifStmt("!" + fieldIsNullTerm, thenBodyWriter -> thenBodyWriter.assignStmt(fieldTerm, CodeGenUtils.rowFieldReadAccess(fieldIndex, inputTerm, attribute.getType())).append(codeBlock).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(attribute.getName() + "=") + " + " + codeBlock.getReturnTerm())), elseBodyWriter -> elseBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(attribute.getName() + "=") + " + " + CastRuleUtils.nullLiteral(context.legacyBehaviour()))));
        }
        writer.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(")")));
        return CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(writer, targetLogicalType, context.legacyBehaviour(), length, resultStringTerm, builderTerm).assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)).toString();
    }
}

