/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlKind;

public abstract class Intersect
extends SetOp {
    protected Intersect(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, List<RelNode> inputs, boolean all) {
        super(cluster, traits, hints, inputs, SqlKind.INTERSECT, all);
    }

    public Intersect(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        this(cluster, traits, Collections.emptyList(), inputs, all);
    }

    protected Intersect(RelInput input) {
        super(input);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double dRows = Double.MAX_VALUE;
        for (RelNode input : this.inputs) {
            Double rowCount = mq.getRowCount(input);
            if (rowCount == null) continue;
            dRows = Math.min(dRows, rowCount);
        }
        return dRows *= 0.25;
    }
}

