/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.concurrent.BlockingQueue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.state.api.runtime.NeverFireProcessingTimeService;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactoryUtil;
import org.apache.flink.streaming.runtime.io.RecordProcessorUtils;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
class BootstrapStreamTask<IN, OUT, OP extends OneInputStreamOperator<IN, OUT> & BoundedOneInput>
extends StreamTask<OUT, OP> {
    private final BlockingQueue<StreamElement> input;
    private final Output<StreamRecord<OUT>> output;
    private ThrowingConsumer<StreamRecord<IN>, Exception> recordProcessor;

    BootstrapStreamTask(Environment environment, BlockingQueue<StreamElement> input, Output<StreamRecord<OUT>> output) throws Exception {
        super(environment, (TimerService)new NeverFireProcessingTimeService());
        this.input = input;
        this.output = output;
    }

    protected void init() throws Exception {
        Preconditions.checkState((this.operatorChain.getNumberOfOperators() == 1 ? 1 : 0) != 0, (Object)"BoundedStreamTask's should only run a single operator");
        StreamOperatorFactory operatorFactory = this.configuration.getStreamOperatorFactory(this.getUserCodeClassLoader());
        Tuple2 mainOperatorAndTimeService = StreamOperatorFactoryUtil.createOperator((StreamOperatorFactory)operatorFactory, (StreamTask)this, (StreamConfig)this.configuration, this.output, (OperatorEventDispatcher)this.operatorChain.getOperatorEventDispatcher());
        this.mainOperator = (StreamOperator)mainOperatorAndTimeService.f0;
        ((OneInputStreamOperator)this.mainOperator).initializeState(this.createStreamTaskStateInitializer());
        ((OneInputStreamOperator)this.mainOperator).open();
        this.recordProcessor = RecordProcessorUtils.getRecordProcessor((Input)((Input)this.mainOperator));
    }

    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        StreamElement element = this.input.take();
        if (element.isRecord()) {
            this.recordProcessor.accept((Object)element.asRecord());
        } else {
            ((BoundedOneInput)((OneInputStreamOperator)this.mainOperator)).endInput();
            ((OneInputStreamOperator)this.mainOperator).finish();
            controller.suspendDefaultAction();
            this.mailboxProcessor.suspend();
        }
    }

    protected void cancelTask() {
    }

    protected void cleanUpInternal() throws Exception {
        ((OneInputStreamOperator)this.mainOperator).close();
    }
}

