/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.join;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.utils.ThrottledIterator;

public class WindowJoinSampleData {
    static final String[] NAMES = new String[]{"tom", "jerry", "alice", "bob", "john", "grace"};
    static final int GRADE_COUNT = 5;
    static final int SALARY_MAX = 10000;

    public static class SalarySource
    implements Iterator<Tuple2<String, Integer>>,
    Serializable {
        private final Random rnd = new Random(this.hashCode());

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Tuple2<String, Integer> next() {
            return new Tuple2((Object)NAMES[this.rnd.nextInt(NAMES.length)], (Object)(this.rnd.nextInt(10000) + 1));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static DataStream<Tuple2<String, Integer>> getSource(StreamExecutionEnvironment env, long rate) {
            return env.fromCollection(new ThrottledIterator<Tuple2<String, Integer>>(new SalarySource(), rate), TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}));
        }
    }

    public static class GradeSource
    implements Iterator<Tuple2<String, Integer>>,
    Serializable {
        private final Random rnd = new Random(this.hashCode());

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Tuple2<String, Integer> next() {
            return new Tuple2((Object)NAMES[this.rnd.nextInt(NAMES.length)], (Object)(this.rnd.nextInt(5) + 1));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static DataStream<Tuple2<String, Integer>> getSource(StreamExecutionEnvironment env, long rate) {
            return env.fromCollection(new ThrottledIterator<Tuple2<String, Integer>>(new GradeSource(), rate), TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}));
        }
    }
}

