/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.log.Log;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.TimeoutCapable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TimeoutManager {
    private static final String LOG_CATEGORY = "Timeout";
    private ScheduledThreadPoolExecutor timeoutService;

    public TimeoutManager() {
        this(null);
    }

    public TimeoutManager(ThreadFactory tf) {
        this(tf, 1);
    }

    public TimeoutManager(ThreadFactory tf, int numberOfThreads) {
        if (tf == null) {
            tf = new MonitorThreadFactory();
        }
        if (numberOfThreads < 1) {
            numberOfThreads = 1;
        }
        this.timeoutService = new ScheduledThreadPoolExecutor(numberOfThreads, tf);
    }

    public Future scheduleTimeout(TimeoutCapable t) {
        ScheduledFuture<?> future = null;
        if (t.getTimeoutPeriod() > 0L) {
            TimeoutTask timeoutTask = new TimeoutTask(t);
            future = this.timeoutService.schedule(timeoutTask, t.getTimeoutPeriod(), TimeUnit.MILLISECONDS);
            t.setTimeoutFuture(future);
            if (t instanceof TimeoutAbstractObject) {
                TimeoutAbstractObject timeoutAbstract = (TimeoutAbstractObject)t;
                timeoutAbstract.setTimeoutManager(this);
                timeoutAbstract.setTimeoutTask(timeoutTask);
            }
            if (Log.isDebug()) {
                Log.getLogger((String)LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has scheduled instance '" + System.identityHashCode(t) + "' of type '" + t.getClass().getName() + "' to be timed out in " + t.getTimeoutPeriod() + " milliseconds. Task queue size: " + this.timeoutService.getQueue().size());
            }
        }
        return future;
    }

    public boolean unscheduleTimeout(TimeoutAbstractObject timeoutAbstract) {
        Runnable unscheduledTimeoutTask;
        Object toRemove = timeoutAbstract.getTimeoutFuture();
        if (!(toRemove instanceof Runnable)) {
            toRemove = timeoutAbstract.getTimeoutTask();
        }
        if (this.timeoutService.remove((Runnable)toRemove)) {
            if (Log.isDebug()) {
                Log.getLogger((String)LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has removed the timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
        } else {
            Future timeoutFuture = timeoutAbstract.getTimeoutFuture();
            timeoutFuture.cancel(false);
            if (Log.isDebug()) {
                Log.getLogger((String)LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' cancelling timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
            if (timeoutFuture.isDone()) {
                this.timeoutService.purge();
                if (Log.isDebug()) {
                    Log.getLogger((String)LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' purged queue of any cancelled or completed tasks. Task queue size: " + this.timeoutService.getQueue().size());
                }
            }
        }
        if ((unscheduledTimeoutTask = timeoutAbstract.getTimeoutTask()) != null && unscheduledTimeoutTask instanceof TimeoutTask) {
            ((TimeoutTask)timeoutAbstract.getTimeoutTask()).clearTimeoutCapable();
        }
        return true;
    }

    public void shutdown() {
        this.timeoutService.shutdownNow();
    }

    class TimeoutTask
    implements Runnable {
        private TimeoutCapable timeoutObject;

        public void clearTimeoutCapable() {
            this.timeoutObject = null;
        }

        public TimeoutTask(TimeoutCapable timeoutObject) {
            this.timeoutObject = timeoutObject;
        }

        @Override
        public void run() {
            block6: {
                TimeoutCapable timeoutObject = this.timeoutObject;
                long inactiveMillis = System.currentTimeMillis() - timeoutObject.getLastUse();
                if (inactiveMillis >= timeoutObject.getTimeoutPeriod()) {
                    try {
                        timeoutObject.timeout();
                        if (Log.isDebug()) {
                            Log.getLogger((String)TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has run the timeout task for instance '" + System.identityHashCode(timeoutObject) + "' of type '" + timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                        }
                        break block6;
                    }
                    catch (Throwable t) {
                        if (Log.isError()) {
                            Log.getLogger((String)TimeoutManager.LOG_CATEGORY).error("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' encountered an error running the timeout task for instance '" + System.identityHashCode(timeoutObject) + "' of type '" + timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size(), t);
                        }
                        break block6;
                    }
                }
                timeoutObject.setTimeoutFuture(TimeoutManager.this.timeoutService.schedule(this, timeoutObject.getTimeoutPeriod() - inactiveMillis, TimeUnit.MILLISECONDS));
                if (Log.isDebug()) {
                    Log.getLogger((String)TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has rescheduled a timeout for the active instance '" + System.identityHashCode(timeoutObject) + "' of type '" + timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                }
            }
        }
    }

    class MonitorThreadFactory
    implements ThreadFactory {
        MonitorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("TimeoutManager");
            return t;
        }
    }
}

