/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.ConnectionAwareSession;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionConnectivityEvent;
import flex.messaging.FlexSessionConnectivityListener;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractConnectionAwareSession
extends FlexSession
implements ConnectionAwareSession {
    private boolean connected;
    private volatile CopyOnWriteArrayList<FlexSessionConnectivityListener> connectivityListeners;

    public AbstractConnectionAwareSession(AbstractFlexSessionProvider sessionProvider) {
        super(sessionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(boolean value) {
        boolean notify = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.connected != value) {
                this.connected = value;
                notify = true;
            }
        }
        if (notify) {
            if (!value) {
                this.notifySessionDisconnected();
            } else {
                this.notifySessionConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectivityListener(FlexSessionConnectivityListener listener) {
        if (this.connectivityListeners == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.connectivityListeners == null) {
                    this.connectivityListeners = new CopyOnWriteArrayList();
                }
            }
        }
        if (this.connectivityListeners.addIfAbsent(listener) && this.isConnected()) {
            FlexSessionConnectivityEvent event = new FlexSessionConnectivityEvent(this);
            listener.sessionConnected(event);
        }
    }

    @Override
    public void removeConnectivityListener(FlexSessionConnectivityListener listener) {
        if (this.connectivityListeners == null) {
            return;
        }
        this.connectivityListeners.remove(listener);
    }

    protected void notifySessionConnected() {
        if (this.connectivityListeners != null) {
            FlexSessionConnectivityEvent event = new FlexSessionConnectivityEvent(this);
            for (FlexSessionConnectivityListener listener : this.connectivityListeners) {
                listener.sessionDisconnected(event);
            }
        }
    }

    protected void notifySessionDisconnected() {
        if (this.connectivityListeners != null) {
            FlexSessionConnectivityEvent event = new FlexSessionConnectivityEvent(this);
            for (FlexSessionConnectivityListener listener : this.connectivityListeners) {
                listener.sessionDisconnected(event);
            }
        }
    }
}

