/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.exceptions.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.exceptions.MessageTooLargeException;
import org.eclipse.jetty.websocket.api.exceptions.ProtocolException;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.eclipse.jetty.websocket.api.exceptions.WebSocketTimeoutException;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrame;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.InvokerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketFrameHandler
implements FrameHandler {
    private final AtomicBoolean closeNotified = new AtomicBoolean();
    private final Logger log;
    private final WebSocketContainer container;
    private final Object endpointInstance;
    private final JettyWebSocketFrameHandlerMetadata metadata;
    private MethodHandle openHandle;
    private MethodHandle closeHandle;
    private MethodHandle errorHandle;
    private MethodHandle textHandle;
    private MethodHandle binaryHandle;
    private final Class<? extends MessageSink> textSinkClass;
    private final Class<? extends MessageSink> binarySinkClass;
    private MethodHandle frameHandle;
    private MethodHandle pingHandle;
    private MethodHandle pongHandle;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private MessageSink textSink;
    private MessageSink binarySink;
    private MessageSink activeMessageSink;
    private WebSocketSession session;

    public JettyWebSocketFrameHandler(WebSocketContainer container, Object endpointInstance, JettyWebSocketFrameHandlerMetadata metadata) {
        this.log = LoggerFactory.getLogger(endpointInstance.getClass());
        this.container = container;
        this.endpointInstance = endpointInstance;
        this.metadata = metadata;
        this.openHandle = InvokerUtils.bindTo(metadata.getOpenHandle(), endpointInstance);
        this.closeHandle = InvokerUtils.bindTo(metadata.getCloseHandle(), endpointInstance);
        this.errorHandle = InvokerUtils.bindTo(metadata.getErrorHandle(), endpointInstance);
        this.textHandle = InvokerUtils.bindTo(metadata.getTextHandle(), endpointInstance);
        this.binaryHandle = InvokerUtils.bindTo(metadata.getBinaryHandle(), endpointInstance);
        this.textSinkClass = metadata.getTextSink();
        this.binarySinkClass = metadata.getBinarySink();
        this.frameHandle = InvokerUtils.bindTo(metadata.getFrameHandle(), endpointInstance);
        this.pingHandle = InvokerUtils.bindTo(metadata.getPingHandle(), endpointInstance);
        this.pongHandle = InvokerUtils.bindTo(metadata.getPongHandle(), endpointInstance);
    }

    public void setUpgradeRequest(UpgradeRequest upgradeRequest) {
        this.upgradeRequest = upgradeRequest;
    }

    public void setUpgradeResponse(UpgradeResponse upgradeResponse) {
        this.upgradeResponse = upgradeResponse;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public void onOpen(CoreSession coreSession, Callback callback) {
        try {
            this.metadata.customize(coreSession);
            this.session = new WebSocketSession(this.container, coreSession, this);
            if (!this.session.isOpen()) {
                throw new IllegalStateException("Session is not open");
            }
            this.frameHandle = InvokerUtils.bindTo(this.frameHandle, this.session);
            this.openHandle = InvokerUtils.bindTo(this.openHandle, this.session);
            this.closeHandle = InvokerUtils.bindTo(this.closeHandle, this.session);
            this.errorHandle = InvokerUtils.bindTo(this.errorHandle, this.session);
            this.textHandle = InvokerUtils.bindTo(this.textHandle, this.session);
            this.binaryHandle = InvokerUtils.bindTo(this.binaryHandle, this.session);
            this.pingHandle = InvokerUtils.bindTo(this.pingHandle, this.session);
            this.pongHandle = InvokerUtils.bindTo(this.pongHandle, this.session);
            if (this.textHandle != null) {
                this.textSink = JettyWebSocketFrameHandler.createMessageSink(this.textSinkClass, this.session, this.textHandle, this.isAutoDemand());
            }
            if (this.binaryHandle != null) {
                this.binarySink = JettyWebSocketFrameHandler.createMessageSink(this.binarySinkClass, this.session, this.binaryHandle, this.isAutoDemand());
            }
            if (this.openHandle != null) {
                this.openHandle.invoke();
            }
            if (this.session.isOpen()) {
                this.container.notifySessionListeners(listener -> listener.onWebSocketSessionOpened(this.session));
            }
            callback.succeeded();
            if (this.openHandle != null) {
                this.autoDemand();
            } else {
                this.internalDemand();
            }
        }
        catch (Throwable cause) {
            callback.failed(new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " OPEN method error: " + cause.getMessage(), cause));
        }
    }

    private static MessageSink createMessageSink(Class<? extends MessageSink> sinkClass, WebSocketSession session, MethodHandle msgHandle, boolean autoDemanding) {
        if (msgHandle == null) {
            return null;
        }
        if (sinkClass == null) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = JettyWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
            MethodHandle ctorHandle = lookup.findConstructor(sinkClass, MethodType.methodType(Void.TYPE, CoreSession.class, MethodHandle.class, Boolean.TYPE));
            return ctorHandle.invoke(session.getCoreSession(), msgHandle, autoDemanding);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing expected MessageSink constructor found at: " + sinkClass.getName(), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create MessageSink: " + sinkClass.getName(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void onFrame(Frame frame, Callback coreCallback) {
        Callback.Completable frameCallback = null;
        if (this.frameHandle != null) {
            try {
                frameCallback = new Callback.Completable();
                this.frameHandle.invoke(new JettyWebSocketFrame(frame), frameCallback);
            }
            catch (Throwable cause) {
                coreCallback.failed(new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " FRAME method error: " + cause.getMessage(), cause));
                return;
            }
        }
        Callback.Completable eventCallback = new Callback.Completable();
        switch (frame.getOpCode()) {
            case 8: {
                this.onCloseFrame(frame, eventCallback);
                break;
            }
            case 9: {
                this.onPingFrame(frame, eventCallback);
                break;
            }
            case 10: {
                this.onPongFrame(frame, eventCallback);
                break;
            }
            case 1: {
                this.onTextFrame(frame, eventCallback);
                break;
            }
            case 2: {
                this.onBinaryFrame(frame, eventCallback);
                break;
            }
            case 0: {
                this.onContinuationFrame(frame, eventCallback);
                break;
            }
            default: {
                coreCallback.failed(new IllegalStateException());
            }
        }
        CompletionStage<Void> callback = eventCallback;
        if (frameCallback != null) {
            callback = frameCallback.thenCompose(ignored -> eventCallback);
        }
        callback.whenComplete((r, x) -> {
            if (x == null) {
                coreCallback.succeeded();
            } else {
                coreCallback.failed((Throwable)x);
            }
        });
    }

    @Override
    public void onError(Throwable cause, Callback callback) {
        try {
            cause = JettyWebSocketFrameHandler.convertCause(cause);
            if (this.errorHandle != null) {
                this.errorHandle.invoke(cause);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Unhandled Error: Endpoint {}", (Object)this.endpointInstance.getClass().getName(), (Object)cause);
            } else {
                this.log.warn("Unhandled Error: Endpoint {} : {}", (Object)this.endpointInstance.getClass().getName(), (Object)cause.toString());
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            WebSocketException wsError = new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " ERROR method error: " + cause.getMessage(), t);
            wsError.addSuppressed(cause);
            callback.failed(wsError);
        }
    }

    @Override
    public void onClosed(CloseStatus closeStatus, Callback callback) {
        this.notifyOnClose(closeStatus, callback);
        this.container.notifySessionListeners(listener -> listener.onWebSocketSessionClosed(this.session));
    }

    private void onCloseFrame(Frame frame, Callback callback) {
        this.notifyOnClose(CloseStatus.getCloseStatus(frame), callback);
    }

    private void notifyOnClose(CloseStatus closeStatus, Callback callback) {
        if (!this.closeNotified.compareAndSet(false, true)) {
            callback.failed(new ClosedChannelException());
            return;
        }
        try {
            if (this.closeHandle != null) {
                this.closeHandle.invoke(closeStatus.getCode(), closeStatus.getReason());
            }
            callback.succeeded();
        }
        catch (Throwable cause) {
            callback.failed(new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " CLOSE method error: " + cause.getMessage(), cause));
        }
    }

    private void onPingFrame(Frame frame, final Callback callback) {
        if (this.pingHandle != null) {
            try {
                ByteBuffer payload = frame.getPayload();
                payload = payload == null ? BufferUtil.EMPTY_BUFFER : BufferUtil.copy(payload);
                this.pingHandle.invoke(payload);
                callback.succeeded();
                this.autoDemand();
            }
            catch (Throwable cause) {
                callback.failed(new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " PING method error: " + cause.getMessage(), cause));
            }
        } else {
            this.getSession().sendPong(frame.getPayload(), new org.eclipse.jetty.websocket.api.Callback(){
                final /* synthetic */ JettyWebSocketFrameHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void succeed() {
                    callback.succeeded();
                    this.this$0.internalDemand();
                }

                @Override
                public void fail(Throwable x) {
                    callback.succeeded();
                    this.this$0.internalDemand();
                }
            });
        }
    }

    private void onPongFrame(Frame frame, Callback callback) {
        if (this.pongHandle != null) {
            try {
                ByteBuffer payload = frame.getPayload();
                payload = payload == null ? BufferUtil.EMPTY_BUFFER : BufferUtil.copy(payload);
                this.pongHandle.invoke(payload);
                callback.succeeded();
                this.autoDemand();
            }
            catch (Throwable cause) {
                callback.failed(new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " PONG method error: " + cause.getMessage(), cause));
            }
        } else {
            this.internalDemand();
        }
    }

    private void onTextFrame(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.textSink;
        }
        this.acceptFrame(frame, callback);
    }

    private void onBinaryFrame(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.binarySink;
        }
        this.acceptFrame(frame, callback);
    }

    private void onContinuationFrame(Frame frame, Callback callback) {
        this.acceptFrame(frame, callback);
    }

    private void acceptFrame(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            callback.succeeded();
            this.internalDemand();
            return;
        }
        MessageSink messageSink = this.activeMessageSink;
        if (frame.isFin()) {
            this.activeMessageSink = null;
        }
        messageSink.accept(frame, callback);
    }

    boolean isAutoDemand() {
        return this.metadata.isAutoDemand();
    }

    private void autoDemand() {
        if (this.isAutoDemand()) {
            this.internalDemand();
        }
    }

    private void internalDemand() {
        this.session.getCoreSession().demand();
    }

    public String toString() {
        return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.endpointInstance.getClass().getName());
    }

    public static Throwable convertCause(Throwable cause) {
        if (cause instanceof org.eclipse.jetty.websocket.core.exception.MessageTooLargeException) {
            return new MessageTooLargeException(cause.getMessage(), cause);
        }
        if (cause instanceof org.eclipse.jetty.websocket.core.exception.ProtocolException) {
            return new ProtocolException(cause.getMessage(), cause);
        }
        if (cause instanceof BadPayloadException) {
            return new org.eclipse.jetty.websocket.api.exceptions.BadPayloadException(cause.getMessage(), cause);
        }
        if (cause instanceof CloseException) {
            return new org.eclipse.jetty.websocket.api.exceptions.CloseException(((CloseException)cause).getStatusCode(), cause.getMessage(), cause);
        }
        if (cause instanceof org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException) {
            return new WebSocketTimeoutException(cause.getMessage(), cause);
        }
        if (cause instanceof InvalidSignatureException) {
            return new InvalidWebSocketException(cause.getMessage(), cause);
        }
        if (cause instanceof org.eclipse.jetty.websocket.core.exception.UpgradeException) {
            org.eclipse.jetty.websocket.core.exception.UpgradeException ue = (org.eclipse.jetty.websocket.core.exception.UpgradeException)cause;
            return new UpgradeException(ue.getRequestURI(), ue.getResponseStatusCode(), cause);
        }
        return cause;
    }
}

