/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.server.http.SegmentLoadingMode;

public class SegmentChangeStatus {
    private final State state;
    @Nullable
    private final String failureCause;
    private final SegmentLoadingMode loadingMode;
    private static final SegmentChangeStatus SUCCESS = new SegmentChangeStatus(State.SUCCESS, null, null);
    private static final SegmentChangeStatus PENDING = new SegmentChangeStatus(State.PENDING, null, null);

    public static SegmentChangeStatus success() {
        return SUCCESS;
    }

    public static SegmentChangeStatus success(SegmentLoadingMode loadingMode) {
        return new SegmentChangeStatus(State.SUCCESS, null, loadingMode);
    }

    public static SegmentChangeStatus pending() {
        return PENDING;
    }

    public static SegmentChangeStatus pending(SegmentLoadingMode loadingMode) {
        return new SegmentChangeStatus(State.PENDING, null, loadingMode);
    }

    public static SegmentChangeStatus failed(String cause, SegmentLoadingMode loadingMode) {
        return new SegmentChangeStatus(State.FAILED, cause, loadingMode);
    }

    public static SegmentChangeStatus failed(String cause) {
        return new SegmentChangeStatus(State.FAILED, cause, null);
    }

    @JsonCreator
    private SegmentChangeStatus(@JsonProperty(value="state") State state, @JsonProperty(value="failureCause") @Nullable String failureCause, @JsonProperty(value="loadingMode") @Nullable SegmentLoadingMode loadingMode) {
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state must be non-null"));
        this.failureCause = failureCause;
        this.loadingMode = loadingMode;
    }

    @JsonProperty
    public State getState() {
        return this.state;
    }

    @Nullable
    @JsonProperty
    public String getFailureCause() {
        return this.failureCause;
    }

    @Nullable
    @JsonProperty
    public SegmentLoadingMode getLoadingMode() {
        return this.loadingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentChangeStatus that = (SegmentChangeStatus)o;
        return this.state == that.state && Objects.equals(this.failureCause, that.failureCause) && this.loadingMode == that.loadingMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.failureCause, this.loadingMode});
    }

    public String toString() {
        return "SegmentChangeStatus{state=" + this.state + ", failureCause='" + this.failureCause + "', loadingMode=" + this.loadingMode + "}";
    }

    public static enum State {
        SUCCESS,
        FAILED,
        PENDING;

    }
}

