/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.joda.time.Period;

public class BrokerSegmentMetadataCacheConfig
extends SegmentMetadataCacheConfig {
    @JsonProperty
    private boolean metadataSegmentCacheEnable = false;
    @JsonProperty
    private long metadataSegmentPollPeriod = 60000L;
    @JsonProperty
    private boolean awaitInitializationOnStart = true;

    public static BrokerSegmentMetadataCacheConfig create() {
        return new BrokerSegmentMetadataCacheConfig();
    }

    public static BrokerSegmentMetadataCacheConfig create(String metadataRefreshPeriod) {
        BrokerSegmentMetadataCacheConfig config = new BrokerSegmentMetadataCacheConfig();
        config.setMetadataRefreshPeriod(new Period((Object)metadataRefreshPeriod));
        return config;
    }

    public boolean isMetadataSegmentCacheEnable() {
        return this.metadataSegmentCacheEnable;
    }

    public long getMetadataSegmentPollPeriod() {
        return this.metadataSegmentPollPeriod;
    }

    public BrokerSegmentMetadataCacheConfig setAwaitInitializationOnStart(boolean awaitInitializationOnStart) {
        this.awaitInitializationOnStart = awaitInitializationOnStart;
        return this;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public String toString() {
        return "BrokerSegmentMetadataCacheConfig{metadataSegmentCacheEnable=" + this.metadataSegmentCacheEnable + ", metadataSegmentPollPeriod=" + this.metadataSegmentPollPeriod + ", awaitInitializationOnStart=" + this.awaitInitializationOnStart + ", metadataRefreshPeriod=" + this.getMetadataRefreshPeriod() + ", metadataColumnTypeMergePolicy=" + this.getMetadataColumnTypeMergePolicy() + "}";
    }
}

