/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.utils.CloseableUtils;

public class ChainedProcessorManager<A, B, R>
implements ProcessorManager<Object, R> {
    @Nullable
    private ProcessorManager<A, List<A>> first;
    private final Function<List<A>, ProcessorManager<B, R>> restFactory;
    private final SettableFuture<ProcessorManager<B, R>> restFuture = SettableFuture.create();
    private boolean closed;
    private final List<A> firstProcessorResult = new CopyOnWriteArrayList<A>();
    private final AtomicInteger firstProcessorCount = new AtomicInteger(0);

    public ChainedProcessorManager(ProcessorManager<A, ?> firstProcessor, Function<List<A>, ProcessorManager<B, R>> restFactory) {
        Preconditions.checkNotNull(firstProcessor, (Object)"first");
        this.first = firstProcessor.withAccumulation(this.firstProcessorResult, (acc, a) -> {
            acc.add(a);
            this.checkFirstProcessorComplete();
            return acc;
        });
        this.restFactory = (Function)Preconditions.checkNotNull(restFactory, (Object)"restFactory");
    }

    public ListenableFuture<Optional<ProcessorAndCallback<Object>>> next() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.first != null) {
            Optional processorAndCallbackOptional = (Optional)Futures.getUnchecked((Future)this.first.next());
            if (processorAndCallbackOptional.isPresent()) {
                this.firstProcessorCount.incrementAndGet();
                ProcessorAndCallback aProcessorAndCallback = (ProcessorAndCallback)processorAndCallbackOptional.get();
                return Futures.immediateFuture(Optional.of(aProcessorAndCallback));
            }
            this.first = null;
            this.checkFirstProcessorComplete();
        }
        return FutureUtils.transformAsync(this.restFuture, rest -> rest.next());
    }

    private void checkFirstProcessorComplete() {
        if (this.first == null && this.firstProcessorResult.size() == this.firstProcessorCount.get()) {
            this.restFuture.set(this.restFactory.apply(this.firstProcessorResult));
        }
    }

    public R result() {
        return (R)((ProcessorManager)FutureUtils.getUncheckedImmediately(this.restFuture)).result();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            CloseableUtils.closeAndWrapExceptions(() -> CloseableUtils.closeAll(this.first != null ? this.first : null, (Closeable[])new Closeable[]{this.restFuture.isDone() ? (Closeable)FutureUtils.getUnchecked(this.restFuture, (boolean)false) : null}));
        }
    }
}

