/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.QueueNonBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.msq.exec.ProcessingBuffers;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.utils.CloseableUtils;

public class DartProcessingBuffersProvider
implements ProcessingBuffersProvider {
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final int processingThreads;

    public DartProcessingBuffersProvider(BlockingPool<ByteBuffer> mergeBufferPool, int processingThreads) {
        this.mergeBufferPool = mergeBufferPool;
        this.processingThreads = processingThreads;
    }

    @Override
    public ResourceHolder<ProcessingBuffersSet> acquire(int poolSize, long timeoutMillis) {
        if (poolSize == 0) {
            return new ReferenceCountingResourceHolder((Object)ProcessingBuffersSet.EMPTY, () -> {});
        }
        List batch = this.mergeBufferPool.takeBatch(1, timeoutMillis);
        if (batch.isEmpty()) {
            throw new MSQException(CanceledFault.timeout());
        }
        ReferenceCountingResourceHolder bufferHolder = (ReferenceCountingResourceHolder)batch.get(0);
        try {
            ByteBuffer buffer = ((ByteBuffer)bufferHolder.get()).duplicate();
            int sliceSize = buffer.capacity() / poolSize / this.processingThreads;
            ArrayList<ProcessingBuffers> pool = new ArrayList<ProcessingBuffers>(poolSize);
            for (int i = 0; i < poolSize; ++i) {
                ArrayBlockingQueue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(this.processingThreads);
                for (int j = 0; j < this.processingThreads; ++j) {
                    int sliceNum = i * this.processingThreads + j;
                    buffer.position(sliceSize * sliceNum).limit(sliceSize * (sliceNum + 1));
                    queue.add(buffer.slice());
                }
                ProcessingBuffers buffers = new ProcessingBuffers((NonBlockingPool<ByteBuffer>)new QueueNonBlockingPool(queue), new Bouncer(this.processingThreads));
                pool.add(buffers);
            }
            return new ReferenceCountingResourceHolder((Object)new ProcessingBuffersSet(pool), (Closeable)bufferHolder);
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, (Closeable)bufferHolder);
        }
    }
}

