/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.indexing.error.MSQErrorReport;

public class WorkerError
implements ControllerMessage {
    private final String queryId;
    private final MSQErrorReport errorWrapper;

    @JsonCreator
    public WorkerError(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="error") MSQErrorReport errorWrapper) {
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        this.errorWrapper = (MSQErrorReport)Preconditions.checkNotNull((Object)errorWrapper, (Object)"error");
    }

    @Override
    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty(value="error")
    public MSQErrorReport getErrorWrapper() {
        return this.errorWrapper;
    }

    @Override
    public void handle(Controller controller) {
        controller.workerError(this.errorWrapper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerError that = (WorkerError)o;
        return Objects.equals(this.queryId, that.queryId) && Objects.equals(this.errorWrapper, that.errorWrapper);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.errorWrapper);
    }

    public String toString() {
        return "WorkerError{queryId='" + this.queryId + "', errorWrapper=" + this.errorWrapper + "}";
    }
}

