/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.runnerstrategy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.k8s.overlord.runnerstrategy.KubernetesRunnerStrategy;
import org.apache.druid.k8s.overlord.runnerstrategy.RunnerStrategy;
import org.apache.druid.k8s.overlord.runnerstrategy.WorkerRunnerStrategy;

public class TaskTypeRunnerStrategy
implements RunnerStrategy {
    @Nullable
    private final Map<String, String> overrides;
    private final RunnerStrategy kubernetesRunnerStrategy = new KubernetesRunnerStrategy();
    private WorkerRunnerStrategy workerRunnerStrategy;
    private final RunnerStrategy defaultRunnerStrategy;
    private final String defaultRunner;

    @JsonCreator
    public TaskTypeRunnerStrategy(@JsonProperty(value="default") String defaultRunner, @JsonProperty(value="overrides") @Nullable Map<String, String> overrides) {
        Preconditions.checkNotNull((Object)defaultRunner);
        this.workerRunnerStrategy = new WorkerRunnerStrategy();
        this.defaultRunnerStrategy = RunnerStrategy.RunnerType.WORKER_RUNNER_TYPE.getType().equals(defaultRunner) ? this.workerRunnerStrategy : this.kubernetesRunnerStrategy;
        this.validate(overrides);
        this.defaultRunner = defaultRunner;
        this.overrides = overrides;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    @JsonProperty
    public String getDefault() {
        return this.defaultRunner;
    }

    @Override
    public RunnerStrategy.RunnerType getRunnerTypeForTask(Task task) {
        String runnerType = null;
        if (this.overrides != null) {
            runnerType = this.overrides.get(task.getType());
        }
        RunnerStrategy runnerStrategy = this.getRunnerSelectStrategy(runnerType);
        return runnerStrategy.getRunnerTypeForTask(task);
    }

    private RunnerStrategy getRunnerSelectStrategy(String runnerType) {
        if (runnerType == null) {
            return this.defaultRunnerStrategy;
        }
        if ("worker".equals(runnerType)) {
            return this.workerRunnerStrategy;
        }
        return this.kubernetesRunnerStrategy;
    }

    private void validate(Map<String, String> overrides) {
        if (overrides == null) {
            return;
        }
        boolean hasValidRunnerType = overrides.values().stream().allMatch(v -> RunnerStrategy.RunnerType.WORKER_RUNNER_TYPE.getType().equals(v) || RunnerStrategy.RunnerType.KUBERNETES_RUNNER_TYPE.getType().equals(v));
        Preconditions.checkArgument((boolean)hasValidRunnerType, (String)"Invalid config in 'overrides'. Each runner type must be either '%s' or '%s'.", (Object)RunnerStrategy.RunnerType.WORKER_RUNNER_TYPE.getType(), (Object)RunnerStrategy.RunnerType.KUBERNETES_RUNNER_TYPE.getType());
    }

    public String toString() {
        return "TaskTypeRunnerStrategy{default=" + this.defaultRunner + ", overrides=" + this.overrides + "}";
    }
}

