/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeFactory;
import org.apache.druid.segment.column.TypeSignature;

public class Types {
    private static final String ARRAY_PREFIX = "ARRAY<";
    private static final String COMPLEX_PREFIX = "COMPLEX<";

    @Nullable
    public static <T extends TypeSignature<?>> T fromString(TypeFactory<T> typeFactory, @Nullable String typeString) {
        if (typeString == null) {
            return null;
        }
        switch (StringUtils.toUpperCase(typeString)) {
            case "STRING": {
                return typeFactory.ofString();
            }
            case "LONG": {
                return typeFactory.ofLong();
            }
            case "FLOAT": {
                return typeFactory.ofFloat();
            }
            case "DOUBLE": {
                return typeFactory.ofDouble();
            }
            case "STRING_ARRAY": {
                return typeFactory.ofArray(typeFactory.ofString());
            }
            case "LONG_ARRAY": {
                return typeFactory.ofArray(typeFactory.ofLong());
            }
            case "DOUBLE_ARRAY": {
                return typeFactory.ofArray(typeFactory.ofDouble());
            }
            case "COMPLEX": {
                return typeFactory.ofComplex(null);
            }
        }
        if (typeString.startsWith(ARRAY_PREFIX)) {
            T elementType = Types.fromString(typeFactory, typeString.substring(ARRAY_PREFIX.length(), typeString.length() - 1));
            Preconditions.checkNotNull(elementType, (Object)"Array element type must not be null");
            return typeFactory.ofArray(elementType);
        }
        if (typeString.startsWith(COMPLEX_PREFIX)) {
            return typeFactory.ofComplex(typeString.substring(COMPLEX_PREFIX.length(), typeString.length() - 1));
        }
        return null;
    }

    public static <T extends TypeDescriptor> boolean is(@Nullable TypeSignature<T> typeSignature, T typeDescriptor) {
        return typeSignature != null && typeSignature.is(typeDescriptor);
    }

    public static <T extends TypeDescriptor> boolean isNullOr(@Nullable TypeSignature<T> typeSignature, T typeDescriptor) {
        return typeSignature == null || typeSignature.is(typeDescriptor);
    }

    public static <T extends TypeDescriptor> boolean isNullOrAnyOf(@Nullable TypeSignature<T> typeSignature, T ... typeDescriptors) {
        return typeSignature == null || typeSignature.anyOf((TypeDescriptor[])typeDescriptors);
    }

    public static <T extends TypeDescriptor> boolean either(@Nullable TypeSignature<T> typeSignature1, @Nullable TypeSignature<T> typeSignature2, T typeDescriptor) {
        return typeSignature1 != null && typeSignature1.is(typeDescriptor) || typeSignature2 != null && typeSignature2.is(typeDescriptor);
    }

    public static <T extends TypeDescriptor> boolean isNumeric(@Nullable TypeSignature<T> typeSignature) {
        return typeSignature != null && typeSignature.isNumeric();
    }

    public static <T extends TypeDescriptor> boolean isNumericOrNumericArray(@Nullable TypeSignature<T> typeSignature) {
        if (typeSignature == null) {
            return false;
        }
        return typeSignature.isNumeric() || typeSignature.isArray() && typeSignature.getElementType().isNumeric();
    }

    public static class InvalidCastBooleanException
    extends IAE {
        public InvalidCastBooleanException(TypeSignature<?> type) {
            super("Invalid type, cannot coerce [" + type + "] to boolean", new Object[0]);
        }
    }

    public static class InvalidCastException
    extends IAE {
        public InvalidCastException(TypeSignature<?> type, TypeSignature<?> other) {
            super("Invalid type, cannot cast [" + type + "] to [" + other + "]", new Object[0]);
        }
    }

    public static class IncompatibleTypeException
    extends IAE {
        public IncompatibleTypeException(TypeSignature<?> type, TypeSignature<?> other) {
            super("Cannot implicitly cast [%s] to [%s]", type, other);
        }
    }
}

