/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.Flushable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.FeedUriExtractor;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.core.ParametrizedUriEmitterConfig;
import org.apache.druid.java.util.emitter.core.ParametrizedUriExtractor;
import org.apache.druid.java.util.emitter.core.UriExtractor;
import org.asynchttpclient.AsyncHttpClient;

public class ParametrizedUriEmitter
implements Flushable,
Closeable,
Emitter {
    private static final Logger log = new Logger(ParametrizedUriEmitter.class);
    private static final Set<String> ONLY_FEED_PARAM = ImmutableSet.of((Object)"feed");
    private final ConcurrentHashMap<URI, HttpPostEmitter> emitters = new ConcurrentHashMap();
    private final UriExtractor uriExtractor;
    private final Object startCloseLock = new Object();
    @GuardedBy(value="startCloseLock")
    private boolean started = false;
    @GuardedBy(value="startCloseLock")
    private boolean closed = false;
    private final Lifecycle innerLifecycle = new Lifecycle();
    private final AsyncHttpClient client;
    private final ObjectMapper jsonMapper;
    private final ParametrizedUriEmitterConfig config;

    private static UriExtractor makeUriExtractor(ParametrizedUriEmitterConfig config) {
        ParametrizedUriExtractor parametrizedUriExtractor;
        String baseUri = config.getRecipientBaseUrlPattern();
        UriExtractor uriExtractor = parametrizedUriExtractor = new ParametrizedUriExtractor(baseUri);
        if (ONLY_FEED_PARAM.equals(parametrizedUriExtractor.getParams())) {
            uriExtractor = new FeedUriExtractor(StringUtils.replace(baseUri, "{feed}", "%s"));
        }
        return uriExtractor;
    }

    public ParametrizedUriEmitter(ParametrizedUriEmitterConfig config, AsyncHttpClient client, ObjectMapper jsonMapper) {
        this(config, client, jsonMapper, ParametrizedUriEmitter.makeUriExtractor(config));
    }

    public ParametrizedUriEmitter(ParametrizedUriEmitterConfig config, AsyncHttpClient client, ObjectMapper jsonMapper, UriExtractor uriExtractor) {
        this.config = config;
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.uriExtractor = uriExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        Object object = this.startCloseLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            try {
                this.innerLifecycle.start();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void emit(Event event) {
        try {
            URI uri = this.uriExtractor.apply(event);
            HttpPostEmitter emitter = this.emitters.get(uri);
            if (emitter == null) {
                try {
                    emitter = this.emitters.computeIfAbsent(uri, u -> {
                        try {
                            return this.innerLifecycle.addMaybeStartManagedInstance(new HttpPostEmitter(this.config.buildHttpEmitterConfig(u.toString()), this.client, this.jsonMapper));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (RuntimeException e) {
                    log.error(e, "Error while creating or starting an HttpPostEmitter for URI[%s]", uri);
                    return;
                }
            }
            emitter.emit(event);
        }
        catch (URISyntaxException e) {
            log.error(e, "Failed to extract URI for event[%s]", event.toMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void close() {
        Object object = this.startCloseLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.innerLifecycle.stop();
        }
    }

    @Override
    public void flush() {
        Exception thrown = null;
        for (HttpPostEmitter httpPostEmitter : this.emitters.values()) {
            try {
                httpPostEmitter.flush();
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    if (thrown != null) {
                        e.addSuppressed(thrown);
                    }
                    throw new RuntimeException(e);
                }
                if (thrown == null) {
                    thrown = e;
                    continue;
                }
                if (thrown == e) continue;
                thrown.addSuppressed(e);
            }
        }
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    public void forEachEmitter(BiConsumer<URI, HttpPostEmitter> action) {
        this.emitters.forEach(action);
    }

    public String toString() {
        return "ParametrizedUriEmitter{emitters=" + (ConcurrentHashMap.KeySetView)this.emitters.keySet() + ", uriExtractor=" + this.uriExtractor + ", config=" + this.config + "}";
    }
}

