/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskIdStatus;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.RE;
import org.joda.time.DateTime;

public class TaskStatusPlus {
    private final String id;
    @Nullable
    private final String type;
    private final DateTime createdTime;
    private final DateTime queueInsertionTime;
    private final TaskState statusCode;
    private final RunnerTaskState runnerTaskState;
    private final Long duration;
    private final TaskLocation location;
    private final String dataSource;
    @Nullable
    private final String errorMsg;
    @Nullable
    private final String groupId;

    public TaskStatusPlus(String id, @Nullable String groupId, @Nullable String type, DateTime createdTime, DateTime queueInsertionTime, @Nullable TaskState statusCode, @Nullable RunnerTaskState runnerStatusCode, @Nullable Long duration, TaskLocation location, @Nullable String dataSource, @Nullable String errorMsg) {
        this(id, groupId, type, createdTime, queueInsertionTime, statusCode, statusCode, runnerStatusCode, duration, location, dataSource, errorMsg);
    }

    @JsonCreator
    public TaskStatusPlus(@JsonProperty(value="id") String id, @JsonProperty(value="groupId") @Nullable String groupId, @JsonProperty(value="type") @Nullable String type, @JsonProperty(value="createdTime") DateTime createdTime, @JsonProperty(value="queueInsertionTime") DateTime queueInsertionTime, @JsonProperty(value="statusCode") @Nullable TaskState statusCode, @Deprecated @JsonProperty(value="status") @Nullable TaskState status, @JsonProperty(value="runnerStatusCode") @Nullable RunnerTaskState runnerTaskState, @JsonProperty(value="duration") @Nullable Long duration, @JsonProperty(value="location") TaskLocation location, @JsonProperty(value="dataSource") @Nullable String dataSource, @JsonProperty(value="errorMsg") @Nullable String errorMsg) {
        if (statusCode != null && statusCode.isComplete()) {
            Preconditions.checkNotNull((Object)duration, (Object)"duration");
        }
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.groupId = groupId;
        this.type = type;
        this.createdTime = (DateTime)Preconditions.checkNotNull((Object)createdTime, (Object)"createdTime");
        this.queueInsertionTime = (DateTime)Preconditions.checkNotNull((Object)queueInsertionTime, (Object)"queueInsertionTime");
        if (statusCode != null && status == null) {
            this.statusCode = statusCode;
        } else if (statusCode == null && status != null) {
            this.statusCode = status;
        } else {
            if (statusCode != null && status != null && statusCode != status) {
                throw new RE("statusCode[%s] and status[%s] must match", new Object[]{statusCode, status});
            }
            this.statusCode = statusCode;
        }
        this.runnerTaskState = runnerTaskState;
        this.duration = duration;
        this.location = (TaskLocation)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.dataSource = dataSource;
        this.errorMsg = errorMsg;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Nullable
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty
    public DateTime getQueueInsertionTime() {
        return this.queueInsertionTime;
    }

    @Nullable
    @JsonProperty(value="statusCode")
    public TaskState getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="status")
    public TaskState getStatus() {
        return this.statusCode;
    }

    @Nullable
    @JsonProperty(value="runnerStatusCode")
    public RunnerTaskState getRunnerStatusCode() {
        return this.runnerTaskState;
    }

    @Nullable
    @JsonProperty
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty
    public TaskLocation getLocation() {
        return this.location;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty(value="errorMsg")
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatusPlus that = (TaskStatusPlus)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getCreatedTime(), that.getCreatedTime()) && Objects.equals(this.getQueueInsertionTime(), that.getQueueInsertionTime()) && this.getStatusCode() == that.getStatusCode() && Objects.equals(this.getDuration(), that.getDuration()) && Objects.equals(this.getLocation(), that.getLocation()) && Objects.equals(this.getDataSource(), that.getDataSource()) && Objects.equals(this.getErrorMsg(), that.getErrorMsg());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getGroupId(), this.getType(), this.getCreatedTime(), this.getQueueInsertionTime(), this.getStatusCode(), this.getDuration(), this.getLocation(), this.getDataSource(), this.getErrorMsg()});
    }

    public String toString() {
        return "TaskStatusPlus{id='" + this.id + "', groupId='" + this.groupId + "', type='" + this.type + "', createdTime=" + this.createdTime + ", queueInsertionTime=" + this.queueInsertionTime + ", statusCode=" + this.statusCode + ", duration=" + this.duration + ", location=" + this.location + ", dataSource='" + this.dataSource + "', errorMsg='" + this.errorMsg + "'}";
    }

    public static TaskStatusPlus fromTaskIdentifierInfo(TaskIdStatus taskIdentifierInfo) {
        TaskStatus status = taskIdentifierInfo.getStatus();
        return new TaskStatusPlus(taskIdentifierInfo.getTaskIdentifier().getId(), taskIdentifierInfo.getTaskIdentifier().getGroupId(), taskIdentifierInfo.getTaskIdentifier().getType(), taskIdentifierInfo.getCreatedTime(), DateTimes.EPOCH, status.getStatusCode(), status.getStatusCode().isComplete() ? RunnerTaskState.NONE : RunnerTaskState.WAITING, status.getDuration(), status.getLocation(), taskIdentifierInfo.getDataSource(), status.getErrorMsg());
    }
}

