/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableInputStreamFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.file.FrameFileFooter;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.storage.StorageConnector;

public class DurableStoragePartitionedReadableFrameChannel
implements PartitionedReadableFrameChannel {
    private final StorageConnector storageConnector;
    private final Supplier<FrameFileFooter> frameFileFooterSupplier;
    private final String frameFileFullPath;
    private final ExecutorService remoteInputStreamPool;
    private final File footerFile;

    public DurableStoragePartitionedReadableFrameChannel(StorageConnector storageConnector, Supplier<FrameFileFooter> frameFileFooterSupplier, String frameFileFullPath, ExecutorService remoteInputStreamPool, File footerFile) {
        this.storageConnector = storageConnector;
        this.frameFileFooterSupplier = frameFileFooterSupplier;
        this.frameFileFullPath = frameFileFullPath;
        this.remoteInputStreamPool = remoteInputStreamPool;
        this.footerFile = footerFile;
    }

    @Override
    public ReadableFrameChannel getReadableFrameChannel(int partitionNumber) {
        long startByte;
        FrameFileFooter frameFileFooter = this.frameFileFooterSupplier.get();
        int startFrame = frameFileFooter.getPartitionStartFrame(partitionNumber);
        int endFrame = frameFileFooter.getPartitionStartFrame(partitionNumber + 1);
        long endByte = endFrame == 0 ? (long)FrameFileWriter.MAGIC.length : frameFileFooter.getFrameEndPosition(endFrame - 1);
        long size = endByte - (startByte = startFrame == 0 ? (long)FrameFileWriter.MAGIC.length : frameFileFooter.getFrameEndPosition(startFrame - 1));
        if (size <= 0L) {
            return ReadableNilFrameChannel.INSTANCE;
        }
        try {
            return ReadableInputStreamFrameChannel.open(this.storageConnector.readRange(this.frameFileFullPath, startByte, endByte - startByte), this.frameFileFullPath, this.remoteInputStreamPool, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.storageConnector.deleteFile(this.frameFileFullPath);
            this.footerFile.delete();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

