/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.TaskLimits;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectUtils;

public class FillCapacityWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final AffinityConfig affinityConfig;
    private final TaskLimits taskLimits;

    @JsonCreator
    public FillCapacityWorkerSelectStrategy(@JsonProperty(value="affinityConfig") AffinityConfig affinityConfig, @JsonProperty(value="taskLimits") @Nullable TaskLimits taskLimits) {
        this.affinityConfig = affinityConfig;
        this.taskLimits = (TaskLimits)Configs.valueOrDefault((Object)taskLimits, (Object)TaskLimits.EMPTY);
    }

    @JsonProperty
    public AffinityConfig getAffinityConfig() {
        return this.affinityConfig;
    }

    @JsonProperty
    public TaskLimits getTaskLimits() {
        return this.taskLimits;
    }

    @Override
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        return WorkerSelectUtils.selectWorker(task, zkWorkers, config, this.affinityConfig, FillCapacityWorkerSelectStrategy::selectFromEligibleWorkers, this.taskLimits);
    }

    static ImmutableWorkerInfo selectFromEligibleWorkers(Map<String, ImmutableWorkerInfo> eligibleWorkers) {
        return eligibleWorkers.values().stream().max(Comparator.comparing(ImmutableWorkerInfo::getCurrCapacityUsed)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillCapacityWorkerSelectStrategy that = (FillCapacityWorkerSelectStrategy)o;
        return Objects.equals(this.affinityConfig, that.affinityConfig) && Objects.equals(this.taskLimits, that.taskLimits);
    }

    public int hashCode() {
        return Objects.hash(this.affinityConfig, this.taskLimits);
    }

    public String toString() {
        return "FillCapacityWorkerSelectStrategy{affinityConfig=" + this.affinityConfig + ", taskLimits=" + this.taskLimits + "}";
    }
}

