/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.repository;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryClientHeartbeatMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DO.JdbcRegistryClientHeartbeat;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryClientHeartbeatDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcRegistryClientRepository {
    @Autowired
    private JdbcRegistryClientHeartbeatMapper jdbcRegistryClientHeartbeatMapper;

    public List<JdbcRegistryClientHeartbeatDTO> queryAll() {
        return this.jdbcRegistryClientHeartbeatMapper.selectAll().stream().map(JdbcRegistryClientHeartbeatDTO::fromJdbcRegistryClientHeartbeat).collect(Collectors.toList());
    }

    public void deleteByIds(List<Long> clientIds) {
        if (CollectionUtils.isEmpty(clientIds)) {
            return;
        }
        this.jdbcRegistryClientHeartbeatMapper.deleteBatchIds(clientIds);
    }

    public boolean updateById(JdbcRegistryClientHeartbeatDTO jdbcRegistryClientHeartbeatDTO) {
        JdbcRegistryClientHeartbeat jdbcRegistryClientHeartbeat = JdbcRegistryClientHeartbeatDTO.toJdbcRegistryClientHeartbeat(jdbcRegistryClientHeartbeatDTO);
        return this.jdbcRegistryClientHeartbeatMapper.updateById(jdbcRegistryClientHeartbeat) == 1;
    }

    public void insert(JdbcRegistryClientHeartbeatDTO jdbcRegistryClient) {
        Preconditions.checkNotNull((Object)jdbcRegistryClient.getId());
        JdbcRegistryClientHeartbeat jdbcRegistryClientHeartbeat = JdbcRegistryClientHeartbeatDTO.toJdbcRegistryClientHeartbeat(jdbcRegistryClient);
        this.jdbcRegistryClientHeartbeatMapper.insert(jdbcRegistryClientHeartbeat);
    }
}

