/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.listener;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.extract.master.command.BackfillWorkflowCommandParam;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.AbstractWorkflowLifecycleLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.WorkflowLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.workflow.listener.IWorkflowLifecycleListener;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowBackfillTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowSuccessLifecycleListener
implements IWorkflowLifecycleListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowSuccessLifecycleListener.class);
    @Autowired
    private WorkflowBackfillTrigger workflowBackfillTrigger;
    @Autowired
    private CommandDao commandDao;

    @Override
    public void notifyWorkflowLifecycleEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, AbstractWorkflowLifecycleLifecycleEvent lifecycleEvent) {
        WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
        if (Flag.YES == workflowInstance.getIsSubWorkflow()) {
            return;
        }
        ICommandParam commandParam = (ICommandParam)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), ICommandParam.class);
        if (commandParam == null) {
            log.warn("Command param: {} is invalid for workflow: {}", (Object)workflowInstance.getCommandParam(), (Object)workflowInstance.getName());
            return;
        }
        if (commandParam.getCommandType() != CommandType.COMPLEMENT_DATA) {
            return;
        }
        this.generateNextBackfillCommand((BackfillWorkflowCommandParam)commandParam, workflowInstance);
    }

    private void generateNextBackfillCommand(BackfillWorkflowCommandParam commandParam, WorkflowInstance workflowInstance) {
        List backfillTimeList = commandParam.getBackfillTimeList();
        backfillTimeList.remove(DateUtils.dateToString((Date)workflowInstance.getScheduleTime()));
        if (CollectionUtils.isEmpty((Collection)backfillTimeList)) {
            return;
        }
        WorkflowBackfillTriggerRequest backfillTriggerRequest = WorkflowBackfillTriggerRequest.builder().userId(Integer.valueOf(workflowInstance.getExecutorId())).backfillTimeList(backfillTimeList).workflowCode(workflowInstance.getWorkflowDefinitionCode()).workflowVersion(Integer.valueOf(workflowInstance.getWorkflowDefinitionVersion())).startNodes(commandParam.getStartNodes()).failureStrategy(workflowInstance.getFailureStrategy()).taskDependType(workflowInstance.getTaskDependType()).warningType(workflowInstance.getWarningType()).warningGroupId(workflowInstance.getWarningGroupId()).workflowInstancePriority(workflowInstance.getWorkflowInstancePriority()).workerGroup(workflowInstance.getWorkerGroup()).tenantCode(workflowInstance.getTenantCode()).environmentCode(workflowInstance.getEnvironmentCode()).startParamList(commandParam.getCommandParams()).dryRun(Flag.of((int)workflowInstance.getDryRun())).build();
        WorkflowBackfillTriggerResponse backfillTriggerResponse = (WorkflowBackfillTriggerResponse)this.workflowBackfillTrigger.triggerWorkflow(backfillTriggerRequest);
        if (!backfillTriggerResponse.isSuccess()) {
            log.warn("Backfill workflow failed: {}", (Object)backfillTriggerResponse.getMessage());
        }
    }

    @Override
    public boolean match(AbstractWorkflowLifecycleLifecycleEvent event) {
        return event.getEventType() == WorkflowLifecycleEventType.SUCCEED;
    }
}

