/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import lombok.Generated;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;

public class WeightedServer<T extends IClusters.IServerMetadata> {
    private T server;
    private double weight;
    private double currentWeight;

    public WeightedServer(T server, double weight) {
        this.server = server;
        this.weight = weight;
        this.currentWeight = 0.0;
    }

    @Generated
    public static <T extends IClusters.IServerMetadata> WeightedServerBuilder<T> builder() {
        return new WeightedServerBuilder();
    }

    @Generated
    public T getServer() {
        return this.server;
    }

    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Generated
    public double getCurrentWeight() {
        return this.currentWeight;
    }

    @Generated
    public void setServer(T server) {
        this.server = server;
    }

    @Generated
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Generated
    public void setCurrentWeight(double currentWeight) {
        this.currentWeight = currentWeight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedServer)) {
            return false;
        }
        WeightedServer other = (WeightedServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getCurrentWeight(), other.getCurrentWeight()) != 0) {
            return false;
        }
        T this$server = this.getServer();
        T other$server = other.getServer();
        return !(this$server == null ? other$server != null : !this$server.equals(other$server));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WeightedServer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        long $currentWeight = Double.doubleToLongBits(this.getCurrentWeight());
        result = result * 59 + (int)($currentWeight >>> 32 ^ $currentWeight);
        T $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeightedServer(server=" + this.getServer() + ", weight=" + this.getWeight() + ", currentWeight=" + this.getCurrentWeight() + ")";
    }

    @Generated
    public WeightedServer(T server, double weight, double currentWeight) {
        this.server = server;
        this.weight = weight;
        this.currentWeight = currentWeight;
    }

    @Generated
    public WeightedServer() {
    }

    @Generated
    public static class WeightedServerBuilder<T extends IClusters.IServerMetadata> {
        @Generated
        private T server;
        @Generated
        private double weight;
        @Generated
        private double currentWeight;

        @Generated
        WeightedServerBuilder() {
        }

        @Generated
        public WeightedServerBuilder<T> server(T server) {
            this.server = server;
            return this;
        }

        @Generated
        public WeightedServerBuilder<T> weight(double weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public WeightedServerBuilder<T> currentWeight(double currentWeight) {
            this.currentWeight = currentWeight;
            return this;
        }

        @Generated
        public WeightedServer<T> build() {
            return new WeightedServer<T>(this.server, this.weight, this.currentWeight);
        }

        @Generated
        public String toString() {
            return "WeightedServer.WeightedServerBuilder(server=" + this.server + ", weight=" + this.weight + ", currentWeight=" + this.currentWeight + ")";
        }
    }
}

