/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.MapComparator;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.repository.WorkerGroupDao;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.utils.MasterThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class WorkerGroupChangeNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerGroupChangeNotifier.class);
    private final MasterConfig masterConfig;
    private final TransactionTemplate transactionTemplate;
    private final WorkerGroupDao workerGroupDao;
    private final List<WorkerGroupListener> listeners = new CopyOnWriteArrayList<WorkerGroupListener>();
    private Map<String, WorkerGroup> workerGroupMap = new HashMap<String, WorkerGroup>();

    public WorkerGroupChangeNotifier(MasterConfig masterConfig, WorkerGroupDao workerGroupDao, TransactionTemplate transactionTemplate) {
        this.masterConfig = masterConfig;
        this.workerGroupDao = workerGroupDao;
        this.transactionTemplate = transactionTemplate;
    }

    public void start() {
        this.detectWorkerGroupChanges();
        long workerGroupRefreshIntervalSeconds = this.masterConfig.getWorkerGroupRefreshInterval().getSeconds();
        MasterThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::detectWorkerGroupChanges, workerGroupRefreshIntervalSeconds, workerGroupRefreshIntervalSeconds, TimeUnit.SECONDS);
    }

    public void subscribeWorkerGroupsChange(WorkerGroupListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void detectWorkerGroupChanges() {
        try {
            MapComparator<String, WorkerGroup> mapComparator = this.detectChangedWorkerGroups();
            this.triggerListeners(mapComparator);
            this.workerGroupMap = mapComparator.getNewMap();
        }
        catch (Exception ex) {
            log.error("Detect WorkerGroup changes failed", (Throwable)ex);
        }
    }

    Map<String, WorkerGroup> getWorkerGroupMap() {
        return this.workerGroupMap;
    }

    private MapComparator<String, WorkerGroup> detectChangedWorkerGroups() {
        return (MapComparator)this.transactionTemplate.execute(status -> {
            Map<String, WorkerGroup> tmpWorkerGroupMap = this.workerGroupDao.queryAll().stream().collect(Collectors.toMap(WorkerGroup::getName, workerGroup -> workerGroup));
            return new MapComparator(this.workerGroupMap, tmpWorkerGroupMap);
        });
    }

    private void triggerListeners(MapComparator<String, WorkerGroup> mapComparator) {
        List workerGroupsUpdated;
        List workerGroupsRemoved;
        if (CollectionUtils.isEmpty(this.listeners)) {
            return;
        }
        List workerGroupsAdded = mapComparator.getValuesToAdd();
        if (CollectionUtils.isNotEmpty((Collection)workerGroupsAdded)) {
            this.listeners.forEach(listener -> listener.onWorkerGroupAdd(workerGroupsAdded));
        }
        if (CollectionUtils.isNotEmpty((Collection)(workerGroupsRemoved = mapComparator.getValuesToRemove()))) {
            this.listeners.forEach(listener -> listener.onWorkerGroupDelete(workerGroupsRemoved));
        }
        if (CollectionUtils.isNotEmpty((Collection)(workerGroupsUpdated = mapComparator.getNewValuesToUpdate()))) {
            this.listeners.forEach(listener -> listener.onWorkerGroupChange(workerGroupsUpdated));
        }
    }

    public static interface WorkerGroupListener {
        public void onWorkerGroupDelete(List<WorkerGroup> var1);

        public void onWorkerGroupAdd(List<WorkerGroup> var1);

        public void onWorkerGroupChange(List<WorkerGroup> var1);
    }
}

