/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.hdfs;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.apache.dolphinscheduler.plugin.storage.hdfs.HdfsStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.hdfs.HdfsStorageProperties;

@AutoService(value={StorageOperatorFactory.class})
public class HdfsStorageOperatorFactory
implements StorageOperatorFactory {
    public StorageOperator createStorageOperate() {
        HdfsStorageProperties hdfsStorageProperties = this.getHdfsStorageProperties();
        return new HdfsStorageOperator(hdfsStorageProperties);
    }

    private HdfsStorageProperties getHdfsStorageProperties() {
        Map configurationProperties = PropertyUtils.getByPrefix((String)"fs.");
        return HdfsStorageProperties.builder().user(PropertyUtils.getString((String)"resource.hdfs.root.user")).defaultFS(PropertyUtils.getString((String)"resource.hdfs.fs.defaultFS")).configurationProperties(configurationProperties).resourceUploadPath(PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler")).build();
    }

    public StorageType getStorageOperate() {
        return StorageType.HDFS;
    }
}

