/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.Nullable;

public class MapResourceFinder
extends ResourceFinder {
    private final Map<String, Resource> map = new HashMap<String, Resource>();
    private long lastModified;

    public MapResourceFinder() {
    }

    public MapResourceFinder(Map<String, byte[]> map) {
        for (Map.Entry<String, byte[]> me : map.entrySet()) {
            Resource prev = this.addResource(me.getKey(), me.getValue());
            assert (prev == null);
        }
    }

    @Nullable
    public Resource addResource(final String fileName, final byte[] data) {
        return this.map.put(fileName, new Resource(){

            public InputStream open() {
                return new ByteArrayInputStream(data);
            }

            public String getFileName() {
                return fileName;
            }

            public long lastModified() {
                return MapResourceFinder.this.lastModified;
            }
        });
    }

    @Nullable
    public Resource addResource(String fileName, String data) {
        return this.addResource(fileName, data.getBytes());
    }

    public void addResource(Resource resource) {
        this.map.put(resource.getFileName(), resource);
    }

    public Collection<Resource> resources() {
        return this.map.values();
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Nullable
    public final Resource findResource(String resourceName) {
        return this.map.get(resourceName);
    }
}

