/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RoleManagementPolicyProperties {
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="isOrganizationDefault")
    private Boolean isOrganizationDefault;
    @JsonProperty(value="lastModifiedBy", access=JsonProperty.Access.WRITE_ONLY)
    private Principal lastModifiedBy;
    @JsonProperty(value="lastModifiedDateTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedDateTime;
    @JsonProperty(value="rules")
    private List<RoleManagementPolicyRule> rules;
    @JsonProperty(value="effectiveRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<RoleManagementPolicyRule> effectiveRules;
    @JsonProperty(value="policyProperties", access=JsonProperty.Access.WRITE_ONLY)
    private PolicyProperties policyProperties;

    public String scope() {
        return this.scope;
    }

    public RoleManagementPolicyProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public RoleManagementPolicyProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RoleManagementPolicyProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    public RoleManagementPolicyProperties withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public List<RoleManagementPolicyRule> rules() {
        return this.rules;
    }

    public RoleManagementPolicyProperties withRules(List<RoleManagementPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    public PolicyProperties policyProperties() {
        return this.policyProperties;
    }

    public void validate() {
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.effectiveRules() != null) {
            this.effectiveRules().forEach(e -> e.validate());
        }
        if (this.policyProperties() != null) {
            this.policyProperties().validate();
        }
    }
}

