/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.KnownLogFilesDataSourceFormat;
import com.azure.resourcemanager.monitor.models.LogFilesDataSourceSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LogFilesDataSource {
    @JsonProperty(value="streams", required=true)
    private List<String> streams;
    @JsonProperty(value="filePatterns", required=true)
    private List<String> filePatterns;
    @JsonProperty(value="format", required=true)
    private KnownLogFilesDataSourceFormat format;
    @JsonProperty(value="settings")
    private LogFilesDataSourceSettings settings;
    @JsonProperty(value="name")
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(LogFilesDataSource.class);

    public List<String> streams() {
        return this.streams;
    }

    public LogFilesDataSource withStreams(List<String> streams) {
        this.streams = streams;
        return this;
    }

    public List<String> filePatterns() {
        return this.filePatterns;
    }

    public LogFilesDataSource withFilePatterns(List<String> filePatterns) {
        this.filePatterns = filePatterns;
        return this;
    }

    public KnownLogFilesDataSourceFormat format() {
        return this.format;
    }

    public LogFilesDataSource withFormat(KnownLogFilesDataSourceFormat format) {
        this.format = format;
        return this;
    }

    public LogFilesDataSourceSettings settings() {
        return this.settings;
    }

    public LogFilesDataSource withSettings(LogFilesDataSourceSettings settings) {
        this.settings = settings;
        return this;
    }

    public String name() {
        return this.name;
    }

    public LogFilesDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.streams() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property streams in model LogFilesDataSource"));
        }
        if (this.filePatterns() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property filePatterns in model LogFilesDataSource"));
        }
        if (this.format() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property format in model LogFilesDataSource"));
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
    }
}

