/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.worker.IStreamingTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointResponse;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.stream.StreamTask;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutor;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamingTaskInstanceOperatorImpl
implements IStreamingTaskInstanceOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingTaskInstanceOperatorImpl.class);
    @Autowired
    private PhysicalTaskExecutorRepository physicalTaskExecutorRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstanceTriggerSavepointResponse triggerSavepoint(TaskInstanceTriggerSavepointRequest taskInstanceTriggerSavepointRequest) {
        log.info("Receive triggerSavepoint request: {}", (Object)taskInstanceTriggerSavepointRequest);
        try {
            int taskInstanceId = taskInstanceTriggerSavepointRequest.getTaskInstanceId();
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            Optional taskExecutorOptional = this.physicalTaskExecutorRepository.get(taskInstanceId);
            if (!taskExecutorOptional.isPresent()) {
                log.error("Cannot find WorkerTaskExecutor for taskInstance: {}", (Object)taskInstanceId);
                TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = TaskInstanceTriggerSavepointResponse.fail((String)"Cannot find TaskExecutionContext");
                return taskInstanceTriggerSavepointResponse;
            }
            PhysicalTaskExecutor taskExecutor = (PhysicalTaskExecutor)((Object)taskExecutorOptional.get());
            AbstractTask task = taskExecutor.getPhysicalTask();
            if (task == null) {
                log.error("Cannot find StreamTask for taskInstance:{}", (Object)taskInstanceId);
                TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = TaskInstanceTriggerSavepointResponse.fail((String)"Cannot find StreamTask");
                return taskInstanceTriggerSavepointResponse;
            }
            if (!(task instanceof StreamTask)) {
                log.warn("The taskInstance: {} is not StreamTask", (Object)taskInstanceId);
                TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = TaskInstanceTriggerSavepointResponse.fail((String)"The taskInstance is not StreamTask");
                return taskInstanceTriggerSavepointResponse;
            }
            try {
                ((StreamTask)task).savePoint();
            }
            catch (Exception e) {
                log.error("StreamTask: {} call savePoint error", (Object)taskInstanceId, (Object)e);
                TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = TaskInstanceTriggerSavepointResponse.fail((String)("StreamTask call savePoint error: " + e.getMessage()));
                LogUtils.removeTaskInstanceIdMDC();
                return taskInstanceTriggerSavepointResponse;
            }
            TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = TaskInstanceTriggerSavepointResponse.success();
            return taskInstanceTriggerSavepointResponse;
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
        }
    }
}

