/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterableBase;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.paging.PageRetrieverSync;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class PagedIterable<T>
extends PagedIterableBase<T, PagedResponse<T>> {
    private final PagedFlux<T> pagedFlux;

    public PagedIterable(PagedFlux<T> pagedFlux) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
    }

    public PagedIterable(Supplier<PagedResponse<T>> firstPageRetriever) {
        this(firstPageRetriever, null);
    }

    public PagedIterable(Function<Integer, PagedResponse<T>> firstPageRetriever) {
        this(firstPageRetriever, (String token, Integer pageSize) -> null);
    }

    public PagedIterable(Supplier<PagedResponse<T>> firstPageRetriever, Function<String, PagedResponse<T>> nextPageRetriever) {
        this(() -> (arg_0, arg_1) -> PagedIterable.lambda$new$1((Supplier)firstPageRetriever, nextPageRetriever, arg_0, arg_1), true);
    }

    public PagedIterable(Function<Integer, PagedResponse<T>> firstPageRetriever, BiFunction<String, Integer, PagedResponse<T>> nextPageRetriever) {
        this(() -> (continuationToken, pageSize) -> continuationToken == null ? (PagedResponse)firstPageRetriever.apply(pageSize) : (PagedResponse)nextPageRetriever.apply((String)continuationToken, pageSize), true);
    }

    public <S> PagedIterable<S> mapPage(Function<T, S> mapper) {
        return new PagedIterable<S>(this.pagedFlux.mapPage(mapper));
    }

    private PagedIterable(Supplier<PageRetrieverSync<String, PagedResponse<T>>> provider, boolean ignored) {
        super(provider);
        this.pagedFlux = null;
    }

    private static /* synthetic */ PagedResponse lambda$new$1(Supplier firstPageRetriever, Function nextPageRetriever, String continuationToken, Integer pageSize) {
        return continuationToken == null ? (PagedResponse)firstPageRetriever.get() : (PagedResponse)nextPageRetriever.apply(continuationToken);
    }
}

