/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.LookupActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Lookup")
public final class LookupActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private LookupActivityTypeProperties innerTypeProperties = new LookupActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(LookupActivity.class);

    private LookupActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public LookupActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public LookupActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public LookupActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public LookupActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public LookupActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public LookupActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public CopySource source() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().source();
    }

    public LookupActivity withSource(CopySource source) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withSource(source);
        return this;
    }

    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    public LookupActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    public Object firstRowOnly() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().firstRowOnly();
    }

    public LookupActivity withFirstRowOnly(Object firstRowOnly) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withFirstRowOnly(firstRowOnly);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model LookupActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

