/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class TaskSchedulerWrapper<T extends TaskScheduler>
implements InitializingBean,
DisposableBean {
    private final T taskScheduler;

    public TaskSchedulerWrapper(T taskScheduler) {
        Assert.notNull(taskScheduler, (String)"ThreadPoolTaskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    public T getTaskScheduler() {
        return this.taskScheduler;
    }

    public void destroy() throws Exception {
        if (DisposableBean.class.isInstance(this.taskScheduler)) {
            ((DisposableBean)this.taskScheduler).destroy();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (InitializingBean.class.isInstance(this.taskScheduler)) {
            ((InitializingBean)this.taskScheduler).afterPropertiesSet();
        }
    }
}

