/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorSmsForm;
import org.casbin.casdoor.util.http.CasdoorResponse;
import org.casbin.casdoor.util.http.HttpClient;

public class CasdoorSmsService {
    private final CasdoorConfig casdoorConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CasdoorSmsService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CasdoorResponse sendSms(String content, String ... receivers) throws IOException {
        String targetUrl = String.format("%s/api/send-sms?clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        CasdoorSmsForm casdoorSmsForm = new CasdoorSmsForm("admin/" + this.casdoorConfig.getOrganizationName(), content, receivers);
        String smsFormStr = this.objectMapper.writeValueAsString((Object)casdoorSmsForm);
        String responseStr = HttpClient.postString(targetUrl, smsFormStr);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }
}

