/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.RingHashLoadBalancer;
import java.util.Map;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long DEFAULT_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_MAX_RING_SIZE = 0x800000L;
    static final long MAX_RING_SIZE = 0x800000L;
    private static final boolean enableRingHash = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return enableRingHash;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "ring_hash";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"maxRingSize");
        if (minRingSize == null) {
            minRingSize = 1024L;
        }
        if (maxRingSize == null) {
            maxRingSize = 0x800000L;
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize || maxRingSize > 0x800000L) {
            return NameResolver.ConfigOrError.fromError((Status)Status.INVALID_ARGUMENT.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize));
    }
}

