/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.TumblingWindowTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.DependencyReference;
import com.azure.resourcemanager.datafactory.models.RetryPolicy;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TumblingWindowFrequency;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="TumblingWindowTrigger")
public final class TumblingWindowTrigger
extends Trigger {
    @JsonProperty(value="pipeline", required=true)
    private TriggerPipelineReference pipeline;
    @JsonProperty(value="typeProperties", required=true)
    private TumblingWindowTriggerTypeProperties innerTypeProperties = new TumblingWindowTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTrigger.class);

    public TriggerPipelineReference pipeline() {
        return this.pipeline;
    }

    public TumblingWindowTrigger withPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    private TumblingWindowTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public TumblingWindowTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public TumblingWindowTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public TumblingWindowFrequency frequency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().frequency();
    }

    public TumblingWindowTrigger withFrequency(TumblingWindowFrequency frequency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withFrequency(frequency);
        return this;
    }

    public int interval() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().interval();
    }

    public TumblingWindowTrigger withInterval(int interval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withInterval(interval);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().startTime();
    }

    public TumblingWindowTrigger withStartTime(OffsetDateTime startTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().endTime();
    }

    public TumblingWindowTrigger withEndTime(OffsetDateTime endTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withEndTime(endTime);
        return this;
    }

    public Object delay() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().delay();
    }

    public TumblingWindowTrigger withDelay(Object delay) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDelay(delay);
        return this;
    }

    public int maxConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().maxConcurrency();
    }

    public TumblingWindowTrigger withMaxConcurrency(int maxConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrency(maxConcurrency);
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().retryPolicy();
    }

    public TumblingWindowTrigger withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRetryPolicy(retryPolicy);
        return this;
    }

    public List<DependencyReference> dependsOn() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dependsOn();
    }

    public TumblingWindowTrigger withDependsOn(List<DependencyReference> dependsOn) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDependsOn(dependsOn);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.pipeline() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property pipeline in model TumblingWindowTrigger"));
        }
        this.pipeline().validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model TumblingWindowTrigger"));
        }
        this.innerTypeProperties().validate();
    }
}

