/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;

@ServiceClient(builder=KeyClientBuilder.class, serviceInterfaces={KeyClientImpl.KeyService.class})
public final class KeyClient {
    private final KeyClientImpl implClient;

    KeyClient(KeyClientImpl implClient) {
        this.implClient = implClient;
    }

    public String getVaultUrl() {
        return this.implClient.getVaultUrl();
    }

    public CryptographyClient getCryptographyClient(String keyName) {
        return this.implClient.getCryptographyClientBuilder(keyName, null).buildClient();
    }

    public CryptographyClient getCryptographyClient(String keyName, String keyVersion) {
        return this.implClient.getCryptographyClientBuilder(keyName, keyVersion).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(String name, KeyType keyType) {
        return (KeyVaultKey)this.createKeyWithResponse(new CreateKeyOptions(name, keyType), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(CreateKeyOptions createKeyOptions) {
        return (KeyVaultKey)this.createKeyWithResponse(createKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        return this.implClient.createKeyWithResponse(createKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return (KeyVaultKey)this.createRsaKeyWithResponse(createRsaKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        return this.implClient.createRsaKeyWithResponse(createRsaKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return (KeyVaultKey)this.createEcKeyWithResponse(createEcKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        return this.implClient.createEcKeyWithResponse(createEcKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return (KeyVaultKey)this.createOctKeyWithResponse(createOctKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        return this.implClient.createOctKeyWithResponse(createOctKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(String name, JsonWebKey keyMaterial) {
        return (KeyVaultKey)this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(ImportKeyOptions importKeyOptions) {
        return (KeyVaultKey)this.importKeyWithResponse(importKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        return this.implClient.importKeyWithResponse(importKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name, String version) {
        return (KeyVaultKey)this.getKeyWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(String name, String version, Context context) {
        return this.implClient.getKeyWithResponse(name, version, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name) {
        return (KeyVaultKey)this.getKeyWithResponse(name, "", Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return (KeyVaultKey)this.updateKeyPropertiesWithResponse(keyProperties, Context.NONE, keyOperations).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        return this.implClient.updateKeyPropertiesWithResponse(keyProperties, context, keyOperations);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedKey, Void> beginDeleteKey(String name) {
        return this.implClient.beginDeleteKeyAsync(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKey getDeletedKey(String name) {
        return (DeletedKey)this.getDeletedKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKey> getDeletedKeyWithResponse(String name, Context context) {
        return this.implClient.getDeletedKeyWithResponse(name, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedKey(String name) {
        this.purgeDeletedKeyWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String name, Context context) {
        return this.implClient.purgeDeletedKeyWithResponse(name, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return this.implClient.beginRecoverDeletedKeyAsync(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupKey(String name) {
        return (byte[])this.backupKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupKeyWithResponse(String name, Context context) {
        return this.implClient.backupKeyWithResponse(name, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey restoreKeyBackup(byte[] backup) {
        return (KeyVaultKey)this.restoreKeyBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        return this.implClient.restoreKeyBackupWithResponse(backup, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys() {
        return this.listPropertiesOfKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedIterable(this.implClient.listPropertiesOfKeys(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys() {
        return this.listDeletedKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys(Context context) {
        return new PagedIterable(this.implClient.listDeletedKeys(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name) {
        return this.listPropertiesOfKeyVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedIterable(this.implClient.listPropertiesOfKeyVersions(name, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] getRandomBytes(int count) {
        return (byte[])this.getRandomBytesWithResponse(count, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> getRandomBytesWithResponse(int count, Context context) {
        return this.implClient.getRandomBytesWithResponse(count, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String targetAttestationToken) {
        return (ReleaseKeyResult)this.releaseKeyWithResponse(name, "", targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String version, String targetAttestationToken) {
        return (ReleaseKeyResult)this.releaseKeyWithResponse(name, version, targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReleaseKeyResult> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions, Context context) {
        return this.implClient.releaseKeyWithResponse(name, version, targetAttestationToken, releaseKeyOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey rotateKey(String name) {
        return (KeyVaultKey)this.rotateKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> rotateKeyWithResponse(String name, Context context) {
        return this.implClient.rotateKeyWithResponse(name, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy getKeyRotationPolicy(String keyName) {
        return (KeyRotationPolicy)this.getKeyRotationPolicyWithResponse(keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String keyName, Context context) {
        return this.implClient.getKeyRotationPolicyWithResponse(keyName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy updateKeyRotationPolicy(String keyName, KeyRotationPolicy keyRotationPolicy) {
        return (KeyRotationPolicy)this.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        return this.implClient.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy, context);
    }
}

