/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIVersions;
import io.kubernetes.client.openapi.models.V1APIVersionsFluent;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDR;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDRBuilder;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDRFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIVersionsFluentImpl<A extends V1APIVersionsFluent<A>>
extends BaseFluent<A>
implements V1APIVersionsFluent<A> {
    private String apiVersion;
    private String kind;
    private List<V1ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs;
    private List<String> versions;

    public V1APIVersionsFluentImpl() {
    }

    public V1APIVersionsFluentImpl(V1APIVersions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String original) {
        return this.withApiVersion(new String(original));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String original) {
        return this.withKind(new String(original));
    }

    @Override
    public A addToServerAddressByClientCIDRs(int index, V1ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
        this._visitables.get("serverAddressByClientCIDRs").add(index >= 0 ? index : this._visitables.get("serverAddressByClientCIDRs").size(), builder);
        this.serverAddressByClientCIDRs.add(index >= 0 ? index : this.serverAddressByClientCIDRs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServerAddressByClientCIDRs(int index, V1ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
        if (index < 0 || index >= this._visitables.get("serverAddressByClientCIDRs").size()) {
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
        } else {
            this._visitables.get("serverAddressByClientCIDRs").set(index, builder);
        }
        if (index < 0 || index >= this.serverAddressByClientCIDRs.size()) {
            this.serverAddressByClientCIDRs.add(builder);
        } else {
            this.serverAddressByClientCIDRs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... items) {
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items) {
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServerAddressByClientCIDRs(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        Iterator<V1ServerAddressByClientCIDRBuilder> each = this.serverAddressByClientCIDRs.iterator();
        Object visitables = this._visitables.get("serverAddressByClientCIDRs");
        while (each.hasNext()) {
            V1ServerAddressByClientCIDRBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return V1APIVersionsFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public List<V1ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
        return V1APIVersionsFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public V1ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index) {
        return this.serverAddressByClientCIDRs.get(index).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(0).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(this.serverAddressByClientCIDRs.size() - 1).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        for (V1ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        for (V1ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this._visitables.get("serverAddressByClientCIDRs").removeAll(this.serverAddressByClientCIDRs);
        }
        if (serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
            for (V1ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        } else {
            this.serverAddressByClientCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs.clear();
        }
        if (serverAddressByClientCIDRs != null) {
            for (V1ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty();
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
        return new ServerAddressByClientCIDRsNestedImpl();
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(V1ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(-1, item);
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index, V1ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(index, item);
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index) {
        if (this.serverAddressByClientCIDRs.size() <= index) {
            throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
        if (this.serverAddressByClientCIDRs.size() == 0) {
            throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(0, this.buildServerAddressByClientCIDR(0));
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
        int index = this.serverAddressByClientCIDRs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public V1APIVersionsFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serverAddressByClientCIDRs.size(); ++i) {
            if (!predicate.test(this.serverAddressByClientCIDRs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public A addToVersions(int index, String item) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        this.versions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, String item) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        this.versions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVersions(String ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        for (String item : items) {
            this.versions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<String> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        for (String item : items) {
            this.versions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(String ... items) {
        for (String item : items) {
            if (this.versions == null) continue;
            this.versions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<String> items) {
        for (String item : items) {
            if (this.versions == null) continue;
            this.versions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVersions() {
        return this.versions;
    }

    @Override
    public String getVersion(int index) {
        return this.versions.get(index);
    }

    @Override
    public String getFirstVersion() {
        return this.versions.get(0);
    }

    @Override
    public String getLastVersion() {
        return this.versions.get(this.versions.size() - 1);
    }

    @Override
    public String getMatchingVersion(Predicate<String> predicate) {
        for (String item : this.versions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVersion(Predicate<String> predicate) {
        for (String item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVersions(List<String> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").removeAll(this.versions);
        }
        if (versions != null) {
            this.versions = new ArrayList<String>();
            for (String item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    @Override
    public A withVersions(String ... versions) {
        if (this.versions != null) {
            this.versions.clear();
        }
        if (versions != null) {
            for (String item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public A addNewVersion(String original) {
        return this.addToVersions(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIVersionsFluentImpl that = (V1APIVersionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.serverAddressByClientCIDRs != null ? !this.serverAddressByClientCIDRs.equals(that.serverAddressByClientCIDRs) : that.serverAddressByClientCIDRs != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.serverAddressByClientCIDRs, this.versions, super.hashCode());
    }

    public class ServerAddressByClientCIDRsNestedImpl<N>
    extends V1ServerAddressByClientCIDRFluentImpl<V1APIVersionsFluent.ServerAddressByClientCIDRsNested<N>>
    implements V1APIVersionsFluent.ServerAddressByClientCIDRsNested<N>,
    Nested<N> {
        private final V1ServerAddressByClientCIDRBuilder builder;
        private final int index;

        ServerAddressByClientCIDRsNestedImpl(int index, V1ServerAddressByClientCIDR item) {
            this.index = index;
            this.builder = new V1ServerAddressByClientCIDRBuilder(this, item);
        }

        ServerAddressByClientCIDRsNestedImpl() {
            this.index = -1;
            this.builder = new V1ServerAddressByClientCIDRBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIVersionsFluentImpl.this.setToServerAddressByClientCIDRs(this.index, this.builder.build());
        }

        @Override
        public N endServerAddressByClientCIDR() {
            return this.and();
        }
    }
}

