/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentDateUtils;

public class DependentUtils {
    private DependentUtils() {
        throw new UnsupportedOperationException("Construct DependentUtils");
    }

    public static DependResult getDependResultForRelation(DependentRelation relation, List<DependResult> dependResultList) {
        DependResult dependResult = DependResult.SUCCESS;
        switch (relation) {
            case AND: {
                if (dependResultList.contains((Object)DependResult.FAILED)) {
                    dependResult = DependResult.FAILED;
                    break;
                }
                if (!dependResultList.contains((Object)DependResult.WAITING)) break;
                dependResult = DependResult.WAITING;
                break;
            }
            case OR: {
                if (dependResultList.contains((Object)DependResult.SUCCESS)) {
                    dependResult = DependResult.SUCCESS;
                    break;
                }
                if (dependResultList.contains((Object)DependResult.WAITING)) {
                    dependResult = DependResult.WAITING;
                    break;
                }
                dependResult = DependResult.FAILED;
                break;
            }
        }
        return dependResult;
    }

    public static List<DateInterval> getDateIntervalList(Date businessDate, String dateValue) {
        List<DateInterval> result = new ArrayList<DateInterval>();
        switch (dateValue) {
            case "currentHour": {
                result = DependentDateUtils.getLastHoursInterval(businessDate, 0);
                break;
            }
            case "last1Hour": {
                result = DependentDateUtils.getLastHoursInterval(businessDate, 1);
                break;
            }
            case "last2Hours": {
                result = DependentDateUtils.getLastHoursInterval(businessDate, 2);
                break;
            }
            case "last3Hours": {
                result = DependentDateUtils.getLastHoursInterval(businessDate, 3);
                break;
            }
            case "last24Hours": {
                result = DependentDateUtils.getSpecialLastDayInterval(businessDate);
                break;
            }
            case "today": {
                result = DependentDateUtils.getTodayInterval(businessDate);
                break;
            }
            case "last1Days": {
                result = DependentDateUtils.getLastDayInterval(businessDate, 1);
                break;
            }
            case "last2Days": {
                result = DependentDateUtils.getLastDayInterval(businessDate, 2);
                break;
            }
            case "last3Days": {
                result = DependentDateUtils.getLastDayInterval(businessDate, 3);
                break;
            }
            case "last7Days": {
                result = DependentDateUtils.getLastDayInterval(businessDate, 7);
                break;
            }
            case "thisWeek": {
                result = DependentDateUtils.getThisWeekInterval(businessDate);
                break;
            }
            case "lastWeek": {
                result = DependentDateUtils.getLastWeekInterval(businessDate);
                break;
            }
            case "lastMonday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 1);
                break;
            }
            case "lastTuesday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 2);
                break;
            }
            case "lastWednesday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 3);
                break;
            }
            case "lastThursday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 4);
                break;
            }
            case "lastFriday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 5);
                break;
            }
            case "lastSaturday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 6);
                break;
            }
            case "lastSunday": {
                result = DependentDateUtils.getLastWeekOneDayInterval(businessDate, 7);
                break;
            }
            case "thisMonth": {
                result = DependentDateUtils.getThisMonthInterval(businessDate);
                break;
            }
            case "thisMonthBegin": {
                result = DependentDateUtils.getNeededMonthBeginInterval(businessDate, true, 0);
                break;
            }
            case "thisMonthEnd": {
                result = DependentDateUtils.getNeededMonthBeginInterval(businessDate, false, 0);
                break;
            }
            case "lastMonth": {
                result = DependentDateUtils.getLastMonthInterval(businessDate);
                break;
            }
            case "lastMonthBegin": {
                result = DependentDateUtils.getNeededMonthBeginInterval(businessDate, true, -1);
                break;
            }
            case "lastMonthEnd": {
                result = DependentDateUtils.getNeededMonthBeginInterval(businessDate, false, -1);
                break;
            }
        }
        return result;
    }

    public static void addTaskVarPool(Map<String, Property> dependItemVarPoolPropertyMap, Map<String, Long> dependItemVarPoolEndTimeMap, Map<String, Property> dependTaskVarPoolPropertyMap, Map<String, Long> dependTaskVarPoolEndTimeMap) {
        dependItemVarPoolPropertyMap.forEach((prop, property) -> {
            Long itemEndTime = (Long)dependItemVarPoolEndTimeMap.get(prop);
            if (dependTaskVarPoolPropertyMap.containsKey(prop)) {
                if (itemEndTime < (Long)dependTaskVarPoolEndTimeMap.get(prop)) {
                    dependTaskVarPoolPropertyMap.put((String)prop, (Property)property);
                    dependTaskVarPoolEndTimeMap.put((String)prop, itemEndTime);
                }
            } else {
                dependTaskVarPoolPropertyMap.put((String)prop, (Property)property);
                dependTaskVarPoolEndTimeMap.put((String)prop, itemEndTime);
            }
        });
    }
}

