/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.worker.IPhysicalTaskExecutorOperator;
import org.apache.dolphinscheduler.extract.worker.IStreamingTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointResponse;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInstanceServiceImpl
extends BaseServiceImpl
implements TaskInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    TaskInstanceDao taskInstanceDao;
    @Autowired
    UsersService usersService;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;

    @Override
    public Result queryTaskListPaging(User loginUser, long projectCode, Integer workflowInstanceId, String workflowInstanceName, String workflowDefinitionName, String taskName, Long taskCode, String executorName, String startDate, String endDate, String searchVal, TaskExecutionStatus stateType, String host, TaskExecuteType taskExecuteType, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:task-instance:view");
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.getCode()};
        }
        Date start = this.checkAndParseDateParameters(startDate);
        Date end = this.checkAndParseDateParameters(endDate);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage taskInstanceIPage = taskExecuteType == TaskExecuteType.STREAM ? this.taskInstanceMapper.queryStreamTaskInstanceListPaging((IPage)page, Long.valueOf(projectCode), workflowDefinitionName, searchVal, taskName, taskCode, executorName, statusArray, host, taskExecuteType, start, end) : this.taskInstanceMapper.queryTaskInstanceListPaging((IPage)page, Long.valueOf(projectCode), workflowInstanceId, workflowInstanceName, searchVal, taskName, taskCode, executorName, statusArray, host, taskExecuteType, start, end);
        List taskInstanceList = taskInstanceIPage.getRecords();
        List<Integer> executorIds = taskInstanceList.stream().map(TaskInstance::getExecutorId).distinct().collect(Collectors.toList());
        List<User> users = this.usersService.queryUser(executorIds);
        Map<Integer, User> userMap = users.stream().collect(Collectors.toMap(User::getId, v -> v));
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstance.setDuration(DateUtils.format2Duration((Date)taskInstance.getStartTime(), (Date)taskInstance.getEndTime()));
            User user = userMap.get(taskInstance.getExecutorId());
            if (user == null) continue;
            taskInstance.setExecutorName(user.getUserName());
        }
        pageInfo.setTotal((int)taskInstanceIPage.getTotal());
        pageInfo.setTotalList(taskInstanceList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void forceTaskSuccess(User loginUser, long projectCode, Integer taskInstanceId) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:task-instance:force-success");
        TaskInstance task = (TaskInstance)this.taskInstanceDao.queryOptionalById((Serializable)taskInstanceId).orElseThrow(() -> new ServiceException(Status.TASK_INSTANCE_NOT_FOUND));
        if (task.getProjectCode() != projectCode) {
            throw new ServiceException("The task instance is not under the project: " + projectCode);
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryOptionalById((Serializable)Integer.valueOf(task.getWorkflowInstanceId())).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, task.getWorkflowInstanceId()));
        if (!workflowInstance.getState().isFinalState()) {
            throw new ServiceException("The workflow instance is not finished: " + workflowInstance.getState() + " cannot force start task instance");
        }
        if (!task.getState().isFailure() && !task.getState().isKill()) {
            throw new ServiceException(Status.TASK_INSTANCE_STATE_OPERATION_ERROR, taskInstanceId, task.getState());
        }
        task.setState(TaskExecutionStatus.FORCED_SUCCESS);
        task.setEndTime(new Date());
        int changedNum = this.taskInstanceMapper.updateById((Object)task);
        if (changedNum <= 0) {
            throw new ServiceException(Status.FORCE_TASK_SUCCESS_ERROR);
        }
        this.processService.forceWorkflowInstanceSuccessByTaskInstanceId(task);
        log.info("Force success task instance:{} success", (Object)taskInstanceId);
    }

    @Override
    public Result taskSavePoint(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-instance:force-success");
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task definition can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = ((IStreamingTaskInstanceOperator)Clients.withService(IStreamingTaskInstanceOperator.class).withHost(taskInstance.getHost())).triggerSavepoint(new TaskInstanceTriggerSavepointRequest(taskInstanceId.intValue()));
        log.info("StreamingTaskInstance trigger savepoint response: {}", (Object)taskInstanceTriggerSavepointResponse);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result stopTask(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-instance:force-success");
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task definition can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        TaskExecutorKillResponse taskExecutorKillResponse = ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(taskInstance.getHost())).killTask(TaskExecutorKillRequest.of((Integer)taskInstanceId));
        log.info("TaskInstance kill response: {}", (Object)taskExecutorKillResponse);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public TaskInstance queryTaskInstanceById(User loginUser, long projectCode, Long taskInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:task-instance:force-success");
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task instance can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
        }
        return taskInstance;
    }

    @Override
    public void deleteByWorkflowInstanceId(Integer workflowInstanceId) {
        List needToDeleteTaskInstances = this.taskInstanceDao.queryByWorkflowInstanceId(workflowInstanceId);
        if (CollectionUtils.isEmpty((Collection)needToDeleteTaskInstances)) {
            return;
        }
        for (TaskInstance taskInstance : needToDeleteTaskInstances) {
            if (!StringUtils.isNotBlank((CharSequence)taskInstance.getLogPath())) continue;
            try {
                ((ILogService)Clients.withService(ILogService.class).withHost(taskInstance.getHost())).removeTaskInstanceLog(taskInstance.getLogPath());
            }
            catch (Exception ex) {
                log.error("Remove task instance log error", (Throwable)ex);
            }
        }
        this.taskGroupQueueService.deleteByWorkflowInstanceId(workflowInstanceId);
        this.taskInstanceDao.deleteByWorkflowInstanceId(workflowInstanceId.intValue());
    }
}

