/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRepeatRunningRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRepeatRunningResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowScheduleTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowScheduleTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.WorkflowCacheRepository;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowBackfillTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowInstanceRecoverFailureTaskTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowInstanceRecoverSuspendTaskTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowInstanceRepeatTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowManualTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowScheduleTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowControlClient
implements IWorkflowControlClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowControlClient.class);
    @Autowired
    private WorkflowManualTrigger workflowManualTrigger;
    @Autowired
    private WorkflowBackfillTrigger workflowBackfillTrigger;
    @Autowired
    private WorkflowScheduleTrigger workflowScheduleTrigger;
    @Autowired
    private WorkflowInstanceRepeatTrigger workflowInstanceRepeatTrigger;
    @Autowired
    private WorkflowInstanceRecoverFailureTaskTrigger workflowInstanceRecoverFailureTaskTrigger;
    @Autowired
    private WorkflowInstanceRecoverSuspendTaskTrigger workflowInstanceRecoverSuspendTaskTrigger;
    @Autowired
    private WorkflowCacheRepository workflowRepository;

    public WorkflowManualTriggerResponse manualTriggerWorkflow(WorkflowManualTriggerRequest manualTriggerRequest) {
        try {
            return (WorkflowManualTriggerResponse)this.workflowManualTrigger.triggerWorkflow(manualTriggerRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowTriggerRequest: {} failed", (Object)manualTriggerRequest, (Object)ex);
            return WorkflowManualTriggerResponse.fail((String)("Trigger workflow failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowBackfillTriggerResponse backfillTriggerWorkflow(WorkflowBackfillTriggerRequest backfillTriggerRequest) {
        try {
            return (WorkflowBackfillTriggerResponse)this.workflowBackfillTrigger.triggerWorkflow(backfillTriggerRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowBackfillTriggerRequest: {} failed", (Object)backfillTriggerRequest, (Object)ex);
            return WorkflowBackfillTriggerResponse.fail((String)("Backfill workflow failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowScheduleTriggerResponse scheduleTriggerWorkflow(WorkflowScheduleTriggerRequest workflowScheduleTriggerRequest) {
        try {
            return (WorkflowScheduleTriggerResponse)this.workflowScheduleTrigger.triggerWorkflow(workflowScheduleTriggerRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowScheduleTriggerRequest: {} failed", (Object)workflowScheduleTriggerRequest, (Object)ex);
            return WorkflowScheduleTriggerResponse.fail((String)("Schedule trigger workflow failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowInstanceRepeatRunningResponse repeatTriggerWorkflowInstance(WorkflowInstanceRepeatRunningRequest workflowInstanceRepeatRunningRequest) {
        try {
            return (WorkflowInstanceRepeatRunningResponse)this.workflowInstanceRepeatTrigger.triggerWorkflow(workflowInstanceRepeatRunningRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowInstanceRepeatRunningRequest: {} failed", (Object)workflowInstanceRepeatRunningRequest, (Object)ex);
            return WorkflowInstanceRepeatRunningResponse.fail((String)("Repeat trigger workflow instance failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowInstanceRecoverFailureTasksResponse triggerFromFailureTasks(WorkflowInstanceRecoverFailureTasksRequest workflowInstanceRecoverFailureTasksRequest) {
        try {
            return (WorkflowInstanceRecoverFailureTasksResponse)this.workflowInstanceRecoverFailureTaskTrigger.triggerWorkflow(workflowInstanceRecoverFailureTasksRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowInstanceRecoverFailureTaskRequest: {} failed", (Object)workflowInstanceRecoverFailureTasksRequest, (Object)ex);
            return WorkflowInstanceRecoverFailureTasksResponse.fail((String)("Recover failure task failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowInstanceRecoverSuspendTasksResponse triggerFromSuspendTasks(WorkflowInstanceRecoverSuspendTasksRequest workflowInstanceRecoverSuspendTasksRequest) {
        try {
            return (WorkflowInstanceRecoverSuspendTasksResponse)this.workflowInstanceRecoverSuspendTaskTrigger.triggerWorkflow(workflowInstanceRecoverSuspendTasksRequest);
        }
        catch (Exception ex) {
            log.error("Handle workflowInstanceRecoverSuspendTaskRequest: {} failed", (Object)workflowInstanceRecoverSuspendTasksRequest, (Object)ex);
            return WorkflowInstanceRecoverSuspendTasksResponse.fail((String)("Recover suspend task failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowInstancePauseResponse pauseWorkflowInstance(WorkflowInstancePauseRequest workflowInstancePauseRequest) {
        try {
            Integer workflowInstanceId = workflowInstancePauseRequest.getWorkflowInstanceId();
            IWorkflowExecutionRunnable workflow = this.workflowRepository.get(workflowInstanceId);
            if (workflow == null) {
                return WorkflowInstancePauseResponse.fail((String)("Cannot find the WorkflowExecuteRunnable: " + workflowInstanceId));
            }
            workflow.pause();
            return WorkflowInstancePauseResponse.success();
        }
        catch (Exception ex) {
            log.error("Handle workflowInstancePauseRequest: {} failed", (Object)workflowInstancePauseRequest, (Object)ex);
            return WorkflowInstancePauseResponse.fail((String)("Pause workflow instance failed: " + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }

    public WorkflowInstanceStopResponse stopWorkflowInstance(WorkflowInstanceStopRequest workflowInstanceStopRequest) {
        try {
            Integer workflowInstanceId = workflowInstanceStopRequest.getWorkflowInstanceId();
            IWorkflowExecutionRunnable workflow = this.workflowRepository.get(workflowInstanceId);
            if (workflow == null) {
                return WorkflowInstanceStopResponse.fail((String)("Cannot find the WorkflowExecuteRunnable: " + workflowInstanceId));
            }
            workflow.stop();
            return WorkflowInstanceStopResponse.success();
        }
        catch (Exception ex) {
            log.error("Handle workflowInstanceStopRequest: {} failed", (Object)workflowInstanceStopRequest, (Object)ex);
            return WorkflowInstanceStopResponse.fail((String)("Stop workflow instance failed:" + ExceptionUtils.getMessage((Throwable)ex)));
        }
    }
}

