/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.wizards.EditEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class OpenEntryEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor valueEditor;

    public OpenEntryEditorAction(TreeViewer viewer, ValueEditorManager valueEditorManager, IValueEditor valueEditor, EntryEditorWidgetActionGroup actionGroup) {
        super(viewer, valueEditorManager, actionGroup);
        this.setCellEditor(valueEditor.getCellEditor());
        this.valueEditor = valueEditor;
    }

    public IValueEditor getValueEditor() {
        return this.valueEditor;
    }

    public void run() {
        IEntry entry;
        Object object = this.getSelectedValues().length > 0 ? this.getSelectedValues()[0].getAttribute().getEntry() : (this.getSelectedAttributes().length > 0 ? this.getSelectedAttributes()[0].getEntry() : (entry = this.getInput() instanceof IEntry ? (IEntry)this.getInput() : null));
        if (entry != null) {
            this.actionGroup.deactivateGlobalActionHandlers();
            EditEntryWizard wizard = new EditEntryWizard(entry);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
            this.actionGroup.activateGlobalActionHandlers();
        }
    }

    public void dispose() {
        this.valueEditor = null;
        super.dispose();
    }

    public String getCommandId() {
        return BrowserCommonConstants.ACTION_ID_EDIT_RECORD;
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_editor.gif");
    }

    public String getText() {
        return Messages.getString("OpenEntryEditorAction.EditEntry");
    }

    public boolean isEnabled() {
        return true;
    }
}

