/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.util.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegExUtil {
    private static final String CLS_NM = RegExUtil.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private String SAFE_TEXT_PATTERN_STRING;
    private static Pattern safeTextPattern;
    private static volatile RegExUtil sINSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegExUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<RegExUtil> clazz = RegExUtil.class;
        synchronized (RegExUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new RegExUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private void init() {
        this.SAFE_TEXT_PATTERN_STRING = Config.getInstance().getProperty("regXSafetext");
        if (this.SAFE_TEXT_PATTERN_STRING != null && this.SAFE_TEXT_PATTERN_STRING.length() != 0) {
            safeTextPattern = Pattern.compile(this.SAFE_TEXT_PATTERN_STRING);
        }
    }

    private RegExUtil() {
        this.init();
    }

    void safeText(String value) throws ValidationException {
        if (Strings.isEmpty((String)this.SAFE_TEXT_PATTERN_STRING)) {
            LOG.debug("safeText can't find safeText regular expression pattern.  Check your Fortress cfg");
        } else {
            Matcher safeTextMatcher = safeTextPattern.matcher(value);
            if (!safeTextMatcher.find()) {
                String error = "safeText has detected invalid value [" + value + "]";
                throw new ValidationException(10001, error);
            }
        }
    }

    static {
        sINSTANCE = null;
    }
}

