/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.directory.fortress.core.model.Address;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;

@XmlRootElement(name="fortUser")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="user", propOrder={"userId", "description", "name", "internalId", "ou", "pwPolicy", "sn", "cn", "dn", "displayName", "employeeType", "title", "address", "phones", "mobiles", "emails", "props", "locked", "reset", "system", "beginTime", "endTime", "beginDate", "endDate", "beginLockDate", "endLockDate", "dayMask", "timeout", "roles", "adminRoles", "password", "newPassword", "uidNumber", "gidNumber", "homeDirectory", "loginShell", "gecos"})
public class User
extends FortEntity
implements Constraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String password;
    private String newPassword;
    private String internalId;
    private List<UserRole> roles;
    private List<UserAdminRole> adminRoles;
    private String pwPolicy;
    private String cn;
    private String sn;
    private String dn;
    private String ou;
    private String displayName;
    private String description;
    private String beginTime;
    private String endTime;
    private String beginDate;
    private String endDate;
    private String beginLockDate;
    private String endLockDate;
    private String dayMask;
    private String name;
    private String employeeType;
    private String title;
    private int timeout;
    private boolean reset;
    private boolean locked;
    private Boolean system;
    private Props props = new Props();
    private Address address;
    private List<String> phones;
    private List<String> mobiles;
    private List<String> emails;
    @XmlTransient
    private byte[] jpegPhoto;
    private String uidNumber;
    private String gidNumber;
    private String homeDirectory;
    private String loginShell;
    private String gecos;

    public String getUidNumber() {
        return this.uidNumber;
    }

    public void setUidNumber(String uidNumber) {
        this.uidNumber = uidNumber;
    }

    public String getGidNumber() {
        return this.gidNumber;
    }

    public void setGidNumber(String gidNumber) {
        this.gidNumber = gidNumber;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public String getLoginShell() {
        return this.loginShell;
    }

    public void setLoginShell(String loginShell) {
        this.loginShell = loginShell;
    }

    public String getGecos() {
        return this.gecos;
    }

    public void setGecos(String gecos) {
        this.gecos = gecos;
    }

    public User() {
    }

    public User(String userId) {
        this.userId = userId;
    }

    public User(String userId, String password) {
        this.userId = userId;
        this.password = password;
    }

    public User(String userId, String password, String[] roleNames) {
        this.userId = userId;
        this.password = password;
        if (roleNames != null) {
            for (String name : roleNames) {
                this.setRole(new UserRole(name));
            }
        }
    }

    public User(String userId, String password, String ou) {
        this.userId = userId;
        this.password = password;
        this.ou = ou;
    }

    public String toString() {
        return "User{userId='" + this.userId + "', internalId='" + this.internalId + "', roles=" + this.roles + ", adminRoles=" + this.adminRoles + ", pwPolicy='" + this.pwPolicy + "', cn='" + this.cn + "', sn='" + this.sn + "', dn='" + this.dn + "', ou='" + this.ou + "', description='" + this.description + "', beginTime='" + this.beginTime + "', endTime='" + this.endTime + "', beginDate='" + this.beginDate + "', endDate='" + this.endDate + "', beginLockDate='" + this.beginLockDate + "', endLockDate='" + this.endLockDate + "', dayMask='" + this.dayMask + "', name='" + this.name + "', employeeType='" + this.employeeType + "', title='" + this.title + "', timeout=" + this.timeout + ", reset=" + this.reset + ", locked=" + this.locked + ", system=" + this.system + ", props=" + this.props + ", address=" + this.address + ", phones=" + this.phones + ", mobiles=" + this.mobiles + ", emails=" + this.emails + "}";
    }

    @Override
    public String getRawData() {
        throw new UnsupportedOperationException("not allowed for user");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPwPolicy() {
        return this.pwPolicy;
    }

    public void setPwPolicy(String pwPolicy) {
        this.pwPolicy = pwPolicy;
    }

    public List<UserRole> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<UserRole>();
        }
        return this.roles;
    }

    public void setRoles(List<UserRole> roles) {
        this.roles = roles;
    }

    public void setRole(UserRole role) {
        if (this.roles == null) {
            this.roles = new ArrayList<UserRole>();
        }
        this.roles.add(role);
    }

    public void setRoleName(String roleName) {
        if (this.roles == null) {
            this.roles = new ArrayList<UserRole>();
        }
        this.roles.add(new UserRole(roleName));
    }

    public void delRole(UserRole role) {
        if (this.roles != null) {
            this.roles.remove(role);
        }
    }

    public List<UserAdminRole> getAdminRoles() {
        if (this.adminRoles == null) {
            this.adminRoles = new ArrayList<UserAdminRole>();
        }
        return this.adminRoles;
    }

    public void setAdminRoles(List<UserAdminRole> roles) {
        this.adminRoles = roles;
    }

    public void setAdminRole(UserAdminRole role) {
        if (this.adminRoles == null) {
            this.adminRoles = new ArrayList<UserAdminRole>();
        }
        this.adminRoles.add(role);
    }

    public void setAdminRoleName(String roleName) {
        if (this.adminRoles == null) {
            this.adminRoles = new ArrayList<UserAdminRole>();
        }
        this.adminRoles.add(new UserAdminRole(this.userId, roleName));
    }

    public void delAdminRole(UserAdminRole adminRole) {
        if (this.adminRoles != null) {
            this.adminRoles.remove(adminRole);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public void setInternalId() {
        UUID uuid = UUID.randomUUID();
        this.internalId = uuid.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getOu() {
        return this.ou;
    }

    public void setOu(String ou) {
        this.ou = ou;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public boolean isTemporalSet() {
        return this.beginTime != null || this.endTime != null || this.beginDate != null || this.endDate != null || this.beginLockDate != null || this.endLockDate != null || this.dayMask != null;
    }

    @Override
    public String getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Override
    public String getBeginDate() {
        return this.beginDate;
    }

    @Override
    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Override
    public String getBeginLockDate() {
        return this.beginLockDate;
    }

    @Override
    public void setBeginLockDate(String beginLockDate) {
        this.beginLockDate = beginLockDate;
    }

    @Override
    public String getEndLockDate() {
        return this.endLockDate;
    }

    @Override
    public void setEndLockDate(String endLockDate) {
        this.endLockDate = endLockDate;
    }

    @Override
    public String getDayMask() {
        return this.dayMask;
    }

    @Override
    public void setDayMask(String dayMask) {
        this.dayMask = dayMask;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Override
    public List<RoleConstraint> getConstraints() {
        throw new UnsupportedOperationException();
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props value) {
        this.props = value;
    }

    public void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public String getProperty(String key) {
        List<Props.Entry> props = this.props.getEntry();
        Props.Entry keyObj = new Props.Entry();
        keyObj.setKey(key);
        String value = null;
        int indx = props.indexOf(keyObj);
        if (indx != -1) {
            Props.Entry entry = props.get(props.indexOf(keyObj));
            value = entry.getValue();
        }
        return value;
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public Address getAddress() {
        if (this.address == null) {
            this.address = new Address();
        }
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public List<String> getPhones() {
        if (this.phones == null) {
            this.phones = new ArrayList<String>();
        }
        return this.phones;
    }

    public void setPhones(List<String> phones) {
        this.phones = phones;
    }

    public void setPhone(String phone) {
        if (this.phones == null) {
            this.phones = new ArrayList<String>();
        }
        this.phones.add(phone);
    }

    public List<String> getMobiles() {
        if (this.mobiles == null) {
            this.mobiles = new ArrayList<String>();
        }
        return this.mobiles;
    }

    public void setMobiles(List<String> mobiles) {
        this.mobiles = mobiles;
    }

    public void setMobile(String mobile) {
        if (this.mobiles == null) {
            this.mobiles = new ArrayList<String>();
        }
        this.mobiles.add(mobile);
    }

    public List<String> getEmails() {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
        }
        return this.emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public void setEmail(String email) {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
        }
        this.emails.add(email);
    }

    public Boolean isSystem() {
        return this.system;
    }

    public void setSystem(Boolean system) {
        this.system = system;
    }

    public byte[] getJpegPhoto() {
        return this.jpegPhoto;
    }

    public void setJpegPhoto(byte[] jpegPhoto) {
        if (jpegPhoto != null) {
            this.jpegPhoto = (byte[])jpegPhoto.clone();
        }
    }

    public int hashCode() {
        return this.userId.toUpperCase().hashCode();
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.userId == null) {
            return false;
        }
        if (!(thatObj instanceof User)) {
            return false;
        }
        User thatUser = (User)thatObj;
        if (thatUser.getUserId() == null) {
            return false;
        }
        return thatUser.getUserId().equalsIgnoreCase(this.userId);
    }
}

