/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.viewaccess;

import jakarta.faces.application.NavigationHandler;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.scope.DeltaSpikeContextExtension;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessContext;
import org.apache.deltaspike.core.spi.activation.Deactivatable;

public class ViewAccessScopedAwareNavigationHandler
extends NavigationHandler
implements Deactivatable {
    private final NavigationHandler navigationHandler;
    private volatile Boolean initialized;
    private DeltaSpikeContextExtension contextExtension;

    public ViewAccessScopedAwareNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        String viewId = null;
        if (context.getViewRoot() != null) {
            viewId = context.getViewRoot().getViewId();
        }
        this.navigationHandler.handleNavigation(context, fromAction, outcome);
        if (viewId != null && context.isPostback()) {
            this.lazyInit();
            ViewAccessContext viewAccessContext = this.contextExtension.getViewAccessScopedContext();
            if (viewAccessContext != null) {
                viewAccessContext.onProcessingViewFinished(viewId);
            }
        }
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            this.contextExtension = (DeltaSpikeContextExtension)BeanProvider.getContextualReference(DeltaSpikeContextExtension.class, (boolean)true, (Annotation[])new Annotation[0]);
            this.initialized = true;
        }
    }
}

