/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.security;

import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.component.UIViewRoot;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.impl.util.SecurityUtils;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;

@RequestScoped
public class ViewRootAccessHandler {
    @Inject
    private ViewConfigResolver viewConfigResolver;
    private List<String> checkedViewIds = new ArrayList<String>();

    public void checkAccessTo(UIViewRoot uiViewRoot) {
        if (uiViewRoot == null) {
            return;
        }
        String viewId = uiViewRoot.getViewId();
        if (!this.checkView(viewId)) {
            return;
        }
        this.checkedViewIds.add(viewId);
        ViewConfigDescriptor configDescriptor = this.viewConfigResolver.getViewConfigDescriptor(viewId);
        Stack<Object> configDescriptorStack = new Stack<Object>();
        if (configDescriptor != null) {
            configDescriptorStack.push(configDescriptor);
        }
        ArrayList<String> parentPathList = new ArrayList<String>();
        this.createPathList(viewId, parentPathList);
        for (String path : parentPathList) {
            ConfigDescriptor pathDescriptor = this.viewConfigResolver.getConfigDescriptor(path);
            if (pathDescriptor == null) continue;
            configDescriptorStack.push(pathDescriptor);
        }
        EditableAccessDecisionVoterContext accessDecisionVoterContext = (EditableAccessDecisionVoterContext)BeanProvider.getContextualReference(EditableAccessDecisionVoterContext.class, (boolean)false, (Annotation[])new Annotation[0]);
        for (ConfigDescriptor configDescriptor2 : configDescriptorStack) {
            SecurityUtils.invokeVoters(accessDecisionVoterContext, configDescriptor2);
        }
    }

    private void createPathList(String currentPath, List<String> pathList) {
        if (!currentPath.contains("/")) {
            return;
        }
        String parentFolder = currentPath.substring(0, currentPath.lastIndexOf("/"));
        pathList.add(parentFolder + "/");
        this.createPathList(parentFolder, pathList);
    }

    private boolean checkView(String viewId) {
        return viewId != null && !this.checkedViewIds.contains(viewId);
    }
}

