/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RollBackWrappingWhenFailOnImportTest
extends BaseJDBCTestCase {
    private String nonexistentFileName = "test/test.dat";

    public RollBackWrappingWhenFailOnImportTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RollBackWrappingWhenFailOnImportTest");
        if (!JDBC.vmSupportsJDBC3()) {
            return baseTestSuite;
        }
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(RollBackWrappingWhenFailOnImportTest.class));
        baseTestSuite.addTest((Test)cleanDatabaseTestSetup);
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        this.openDefaultConnection();
        MockInternalDriver mockInternalDriver = new MockInternalDriver();
        mockInternalDriver.boot(false, null);
        SupportFilesSetup.deleteFile(this.nonexistentFileName);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.getTestConfiguration().shutdownEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testRollBackWhenFailOnImportTable() throws SQLException {
        String string = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP', '" + this.nonexistentFileName + "test/test.dat' , null, null, null, 0) ";
        this.realTestRollBackWhenImportOnNonexistentFile(string);
    }

    public void testRollBackWhenFailOnImportTableLobsFromEXTFile() throws SQLException {
        String string = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'IET1' , '" + this.nonexistentFileName + "', null, null, null, 0)";
        this.realTestRollBackWhenImportOnNonexistentFile(string);
    }

    public void testRollBackWhenFailOnImportData() throws SQLException {
        String string = "call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP', null, null, '" + this.nonexistentFileName + "', null, null, null, 1) ";
        this.realTestRollBackWhenImportOnNonexistentFile(string);
    }

    public void testRollBackWhenFailOnImportDataLobsFromExtFile() throws SQLException {
        String string = "call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'IET1', null, null, '" + this.nonexistentFileName + "', null, null, null, 1)";
        this.realTestRollBackWhenImportOnNonexistentFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realTestRollBackWhenImportOnNonexistentFile(String string) throws SQLException {
        try (CallableStatement callableStatement = this.prepareCall(string);){
            callableStatement.executeUpdate();
            RollBackWrappingWhenFailOnImportTest.fail((String)"a SQLException should be thrown as we import data from a nonexistent file");
        }
    }

    class MockInternalDriver
    extends InternalDriver {
        MockInternalDriver() {
        }

        public Connection connect(String string, Properties properties, int n) {
            Connection connection = null;
            try {
                connection = super.connect(string, properties, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new MockConnectionFailWhenRollBack(connection);
        }

        public class MockConnectionFailWhenRollBack
        extends EmbedConnection {
            public MockConnectionFailWhenRollBack(Connection connection) {
                super((EmbedConnection)connection);
            }

            public void rollback() throws SQLException {
                throw new SQLException("error in roll back", "XJ058");
            }
        }
    }
}

